/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.HashMap;
import org.compass.core.mapping.osem.AbstractAccessorMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;

public abstract class AbstractRefAliasMapping
extends AbstractAccessorMapping
implements HasRefAliasMapping {
    private String[] refAliases;
    private ClassMapping[] refClassMappings;
    private Class refClass;
    private HashMap refAliasesMap = new HashMap();

    protected void copy(AbstractRefAliasMapping mapping) {
        super.copy(mapping);
        if (this.refAliases != null) {
            String[] copyRefAliases = new String[this.refAliases.length];
            System.arraycopy(this.refAliases, 0, copyRefAliases, 0, this.refAliases.length);
            mapping.setRefAliases(copyRefAliases);
        }
        mapping.setRefClass(this.getRefClass());
        if (this.refClassMappings != null) {
            ClassMapping[] copyRefClassMappings = new ClassMapping[this.refClassMappings.length];
            System.arraycopy(this.refClassMappings, 0, copyRefClassMappings, 0, this.refClassMappings.length);
            mapping.setRefClassMappings(copyRefClassMappings);
        }
    }

    public boolean hasRefAlias(String refAlias) {
        return this.refAliasesMap.get(refAlias) != null;
    }

    public boolean hasAtLeastOneRefAlias(String[] refAliases) {
        if (refAliases == null) {
            return false;
        }
        for (int i = 0; i < refAliases.length; ++i) {
            if (!this.hasRefAlias(refAliases[i])) continue;
            return true;
        }
        return false;
    }

    public ClassMapping getRefClassMapping(String alias) {
        return (ClassMapping)this.refAliasesMap.get(alias);
    }

    public String[] getRefAliases() {
        return this.refAliases;
    }

    public void setRefAliases(String[] refAliases) {
        this.refAliases = refAliases;
    }

    public ClassMapping[] getRefClassMappings() {
        return this.refClassMappings;
    }

    public void setRefClassMappings(ClassMapping[] refClassMappings) {
        this.refClassMappings = refClassMappings;
        if (refClassMappings != null) {
            for (int i = 0; i < refClassMappings.length; ++i) {
                this.refAliasesMap.put(refClassMappings[i].getAlias(), refClassMappings[i]);
            }
        }
    }

    public Class getRefClass() {
        return this.refClass;
    }

    public void setRefClass(Class refClass) {
        this.refClass = refClass;
    }
}

