/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction;

import java.util.ArrayList;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.LuceneSearchEngineQuery;
import org.compass.core.lucene.engine.analyzer.LuceneAnalyzerManager;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.transaction.LuceneSearchEngineTransaction;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public abstract class AbstractTransaction
implements LuceneSearchEngineTransaction {
    protected LuceneSearchEngine searchEngine;
    protected LuceneSearchEngineIndexManager indexManager;
    protected CompassMapping mapping;
    protected LuceneAnalyzerManager analyzerManager;
    private ArrayList delegateClose = new ArrayList();
    protected boolean dirty;

    public void configure(LuceneSearchEngine searchEngine) {
        this.searchEngine = searchEngine;
        this.indexManager = searchEngine.getSearchEngineFactory().getLuceneIndexManager();
        this.mapping = searchEngine.getSearchEngineFactory().getMapping();
        this.analyzerManager = searchEngine.getSearchEngineFactory().getAnalyzerManager();
    }

    public void begin() throws SearchEngineException {
        this.closeDelegateClosed();
        this.doBegin();
    }

    protected abstract void doBegin() throws SearchEngineException;

    public void rollback() throws SearchEngineException {
        this.closeDelegateClosed();
        this.doRollback();
    }

    protected abstract void doRollback() throws SearchEngineException;

    public void prepare() throws SearchEngineException {
        this.doPrepare();
    }

    protected abstract void doPrepare() throws SearchEngineException;

    public void commit(boolean onePhase) throws SearchEngineException {
        this.closeDelegateClosed();
        this.doCommit(onePhase);
    }

    protected abstract void doCommit(boolean var1) throws SearchEngineException;

    public SearchEngineHits find(SearchEngineQuery query) throws SearchEngineException {
        SearchEngineHits hits = this.doFind((LuceneSearchEngineQuery)query);
        this.delegateClose.add(hits);
        return hits;
    }

    protected abstract SearchEngineHits doFind(LuceneSearchEngineQuery var1) throws SearchEngineException;

    public SearchEngineInternalSearch internalSearch(String[] subIndexes, String[] aliases) throws SearchEngineException {
        SearchEngineInternalSearch internalSearch = this.doInternalSearch(subIndexes, aliases);
        this.delegateClose.add(internalSearch);
        return internalSearch;
    }

    protected abstract SearchEngineInternalSearch doInternalSearch(String[] var1, String[] var2) throws SearchEngineException;

    public void create(InternalResource resource) throws SearchEngineException {
        this.dirty = true;
        this.doCreate(resource);
    }

    protected abstract void doCreate(InternalResource var1) throws SearchEngineException;

    public void delete(ResourceKey resourceKey) throws SearchEngineException {
        this.dirty = true;
        this.doDelete(resourceKey);
    }

    protected abstract void doDelete(ResourceKey var1) throws SearchEngineException;

    public boolean isDirty() {
        return this.dirty;
    }

    protected void closeDelegateClosed() throws SearchEngineException {
        for (int i = 0; i < this.delegateClose.size(); ++i) {
            try {
                ((LuceneDelegatedClose)this.delegateClose.get(i)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.delegateClose.clear();
    }

    protected ResourceMapping getResourceMapping(String alias) {
        return this.mapping.getRootMappingByAlias(alias);
    }
}

