/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractLuceneSearchEngineStore;

public class RAMLuceneSearchEngineStore
extends AbstractLuceneSearchEngineStore {
    private Map ramIndexes = new HashMap();

    public RAMLuceneSearchEngineStore(String path, String subContext) {
        super(path, subContext);
    }

    protected synchronized Directory doOpenDirectoryBySubIndex(String subIndex, boolean create) throws SearchEngineException {
        RAMDirectory directory = (RAMDirectory)this.ramIndexes.get(subIndex);
        if (directory == null && create) {
            directory = new RAMDirectory();
            this.ramIndexes.put(subIndex, directory);
        }
        return directory;
    }

    protected synchronized void doDeleteIndex() throws SearchEngineException {
        if (this.ramIndexes != null) {
            this.ramIndexes.clear();
        }
    }

    protected void doClose() {
        if (this.ramIndexes != null) {
            this.ramIndexes.clear();
            this.ramIndexes = null;
        }
    }
}

