/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import org.compass.core.lucene.engine.store.FSLuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.JdbcLuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.MMapLuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.RAMLuceneSearchEngineStore;

public class LuceneSearchEngineStoreFactory {
    public static final String MEM_PREFIX = "ram://";
    public static final String FILE_PREFIX = "file://";
    public static final String MMAP_PREFIX = "mmap://";
    public static final String JDBC_PREFIX = "jdbc://";

    public static LuceneSearchEngineStore createStore(String connection, String subContext) {
        if (connection.startsWith(MEM_PREFIX)) {
            return new RAMLuceneSearchEngineStore(connection.substring(MEM_PREFIX.length(), connection.length()), subContext);
        }
        if (connection.startsWith(MMAP_PREFIX)) {
            return new MMapLuceneSearchEngineStore(connection.substring(MMAP_PREFIX.length(), connection.length()), subContext);
        }
        if (connection.startsWith(FILE_PREFIX)) {
            return new FSLuceneSearchEngineStore(connection.substring(FILE_PREFIX.length(), connection.length()), subContext);
        }
        if (connection.startsWith(JDBC_PREFIX)) {
            return new JdbcLuceneSearchEngineStore(connection.substring(JDBC_PREFIX.length(), connection.length()), subContext);
        }
        return new FSLuceneSearchEngineStore(connection, subContext);
    }
}

