/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.optimizer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.LuceneSubIndexInfo;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.lucene.engine.optimizer.LuceneSearchEngineOptimizer;

public abstract class AbstractLuceneSearchEngineOptimizer
implements LuceneSearchEngineOptimizer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private LuceneSearchEngineFactory searchEngineFactory;
    private boolean isRunning = false;

    public void start() throws SearchEngineException {
        if (this.isRunning) {
            throw new IllegalStateException("Optimizer is already running");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Starting Optimizer");
        }
        this.doStart();
        this.isRunning = true;
    }

    protected void doStart() throws SearchEngineException {
    }

    public void stop() throws SearchEngineException {
        if (!this.isRunning) {
            throw new IllegalStateException("Optimizer is is not running");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping Optimizer");
        }
        this.doStop();
        this.isRunning = false;
    }

    protected void doStop() throws SearchEngineException {
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void optimize() throws SearchEngineException {
        LuceneSearchEngineIndexManager indexManager = this.searchEngineFactory.getLuceneIndexManager();
        String[] subIndexes = indexManager.getStore().getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            this.searchEngineFactory.getOptimizer().optimize(subIndexes[i]);
        }
    }

    public void optimize(String subIndex) throws SearchEngineException {
        LuceneSubIndexInfo indexInfo;
        if (!this.isRunning()) {
            return;
        }
        LuceneSearchEngineIndexManager indexManager = this.searchEngineFactory.getLuceneIndexManager();
        try {
            indexInfo = LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read index info for sub index [" + subIndex + "]", e);
        }
        if (indexInfo == null) {
            return;
        }
        boolean needOptimizing = this.doNeedOptimizing(subIndex, indexInfo);
        if (!this.isRunning()) {
            return;
        }
        if (needOptimizing) {
            this.doOptimize(subIndex, indexInfo);
            this.searchEngineFactory.getIndexManager().clearCache(subIndex);
        }
    }

    public boolean needOptimization() throws SearchEngineException {
        LuceneSearchEngineIndexManager indexManager = this.searchEngineFactory.getLuceneIndexManager();
        String[] subIndexes = indexManager.getStore().getSubIndexes();
        boolean needOptmization = false;
        for (int i = 0; i < subIndexes.length; ++i) {
            needOptmization |= this.searchEngineFactory.getOptimizer().needOptimization(subIndexes[i]);
        }
        return needOptmization;
    }

    public boolean needOptimization(String subIndex) throws SearchEngineException {
        LuceneSubIndexInfo indexInfo;
        LuceneSearchEngineIndexManager indexManager = this.searchEngineFactory.getLuceneIndexManager();
        if (!this.isRunning()) {
            return false;
        }
        try {
            indexInfo = LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to read index info for sub index [" + subIndex + "]", e);
        }
        if (indexInfo == null) {
            return false;
        }
        return this.doNeedOptimizing(subIndex, indexInfo);
    }

    protected abstract void doOptimize(String var1, LuceneSubIndexInfo var2) throws SearchEngineException;

    protected abstract boolean doNeedOptimizing(String var1, LuceneSubIndexInfo var2) throws SearchEngineException;

    public LuceneSearchEngineFactory getSearchEngineFactory() {
        return this.searchEngineFactory;
    }

    public void setSearchEngineFactory(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }
}

