/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.highlighter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.highlighter.DefaultLuceneHighlighterFactory;
import org.compass.core.lucene.engine.highlighter.DefaultLuceneHighlighterSettings;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterFactory;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;
import org.compass.core.util.ClassUtils;

public class LuceneHighlighterManager {
    private static final Log log = LogFactory.getLog((Class)LuceneHighlighterManager.class);
    private LuceneHighlighterSettings defaultHighlighterSettings;
    private HashMap highlightersSettings = new HashMap();

    public void configure(CompassSettings settings) throws SearchEngineException {
        Map highlighterSettingGroups = settings.getSettingGroups("compass.engine.highlighter");
        Iterator it = highlighterSettingGroups.keySet().iterator();
        while (it.hasNext()) {
            String highlighterName = (String)it.next();
            if (log.isInfoEnabled()) {
                log.info((Object)("Building highlighter [" + highlighterName + "]"));
            }
            LuceneHighlighterSettings highlighter = this.buildHighlighter(highlighterName, (CompassSettings)highlighterSettingGroups.get(highlighterName));
            this.highlightersSettings.put(highlighterName, highlighter);
        }
        this.defaultHighlighterSettings = (DefaultLuceneHighlighterSettings)this.highlightersSettings.get("default");
        if (this.defaultHighlighterSettings == null) {
            this.defaultHighlighterSettings = this.buildHighlighter("default", new CompassSettings());
            this.highlightersSettings.put("default", this.defaultHighlighterSettings);
        }
    }

    private LuceneHighlighterSettings buildHighlighter(String highlighterName, CompassSettings settings) {
        LuceneHighlighterFactory highlighterFactory;
        String highlighterFactorySetting = settings.getSetting("factory", null);
        if (highlighterFactorySetting == null) {
            highlighterFactory = new DefaultLuceneHighlighterFactory();
        } else {
            try {
                highlighterFactory = (LuceneHighlighterFactory)ClassUtils.forName(highlighterFactorySetting).newInstance();
            }
            catch (Exception e) {
                throw new SearchEngineException("Cannot create Highlighter factory [" + highlighterFactorySetting + "]. Please verify the highlighter factory setting at [" + "factory" + "]", e);
            }
        }
        return highlighterFactory.createHighlighterSettings(highlighterName, settings);
    }

    public LuceneHighlighterSettings getDefaultHighlighterSettings() {
        return this.defaultHighlighterSettings;
    }

    public LuceneHighlighterSettings getHighlighterSettings(String highlighterName) {
        return (LuceneHighlighterSettings)this.highlightersSettings.get(highlighterName);
    }

    public LuceneHighlighterSettings getHighlighterSettingsMustExists(String highlighterName) {
        LuceneHighlighterSettings highlighterSettings = (LuceneHighlighterSettings)this.highlightersSettings.get(highlighterName);
        if (highlighterSettings == null) {
            throw new SearchEngineException("No highlighter is defined for highlighter name [" + highlighterName + "]");
        }
        return highlighterSettings;
    }
}

