/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;

public class LuceneSearchEngineInternalSearch
implements SearchEngineInternalSearch,
LuceneDelegatedClose {
    private MultiSearcher searcher;
    protected MultiReader reader;
    private boolean closed;
    private List indexHolders;

    public LuceneSearchEngineInternalSearch(MultiSearcher searcher, List indexHolders) {
        this.searcher = searcher;
        this.indexHolders = indexHolders;
    }

    public boolean isEmpty() {
        return this.searcher == null || this.searcher.getSearchables().length == 0;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public IndexReader getReader() throws SearchEngineException {
        if (this.reader != null) {
            return this.reader;
        }
        Searchable[] searchables = this.searcher.getSearchables();
        IndexReader[] readers = new IndexReader[searchables.length];
        for (int i = 0; i < searchables.length; ++i) {
            readers[i] = ((IndexSearcher)searchables[i]).getIndexReader();
        }
        try {
            this.reader = new MultiReader(readers);
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open readers", e);
        }
        return this.reader;
    }

    public void close() throws SearchEngineException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.indexHolders != null) {
            for (int i = 0; i < this.indexHolders.size(); ++i) {
                LuceneSearchEngineIndexManager.LuceneIndexHolder indexHolder = (LuceneSearchEngineIndexManager.LuceneIndexHolder)this.indexHolders.get(i);
                indexHolder.release();
            }
        }
    }
}

