/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.engine.subindex;

import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.subindex.SubIndexHash;

public class ModuloSubIndexHash
implements SubIndexHash,
CompassConfigurable {
    private String prefix;
    private int size;

    public ModuloSubIndexHash() {
    }

    public ModuloSubIndexHash(String prefix, int size) {
        this.prefix = prefix;
        this.size = size;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.prefix = settings.getSetting("prefix", null);
        if (this.prefix == null) {
            throw new ConfigurationException("prefix must be set for Modulo sub index hash");
        }
        this.size = settings.getSettingAsInt("size", -1);
        if (this.size < 0) {
            throw new ConfigurationException("size must be set for Modulo sub index hash");
        }
    }

    public String[] getSubIndexes() {
        String[] subIndexes = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            subIndexes[i] = this.prefix + '_' + i;
        }
        return subIndexes;
    }

    public String mapSubIndex(String alias, Property[] ids) throws SearchEngineException {
        int hash = alias.hashCode();
        for (int i = 0; i < ids.length; ++i) {
            hash = hash * 31 + ids[i].getStringValue().hashCode();
        }
        return this.prefix + '_' + hash % this.size;
    }

    public String toString() {
        return "ModuloSubIndexHash[prefix[" + this.prefix + "] size[" + this.size + "]]";
    }
}

