/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.xsem;

import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.util.ClassUtils;

public abstract class XmlContentConverterUtils {
    public static XmlContentConverter createXmlContentConverter(CompassSettings settings) throws ConfigurationException {
        String wrapper;
        String type = settings.getSetting("xmlContentConverter.type");
        if (type == null) {
            throw new ConfigurationException("xmlContent type configuration can not be found, please set it in the configuration settings");
        }
        XmlContentConverter xmlContentConverter = null;
        try {
            xmlContentConverter = (XmlContentConverter)ClassUtils.forName(type).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create xmlContent [" + type + "]", e);
        }
        if (xmlContentConverter instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)xmlContentConverter)).configure(settings);
        }
        if (xmlContentConverter instanceof SupportsXmlContentWrapper && !((SupportsXmlContentWrapper)((Object)xmlContentConverter)).supports(wrapper = settings.getSetting("xmlContentConverter.wrapper", "prototype"))) {
            throw new SupportsXmlContentWrapper.NotSupportedXmlContentWrapperException(xmlContentConverter, wrapper);
        }
        return xmlContentConverter;
    }
}

