/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.xsem;

import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlContentMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlConverterUtils;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.spi.MultiResource;
import org.compass.core.xml.RawXmlObject;
import org.compass.core.xml.XmlObject;

public class XmlObjectMappingConverter
implements ResourceMappingConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        if (root == null && !context.handleNulls()) {
            return false;
        }
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        XmlObject rootXmlObject = (XmlObject)root;
        rootXmlObject = this.getActualXmlObject(rootXmlObject, xmlObjectMapping, context, resource);
        if (xmlObjectMapping.getXPath() != null) {
            XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
            if (xmlObjects == null || xmlObjects.length == 0) {
                throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
            }
            boolean store = false;
            MultiResource multiResource = (MultiResource)resource;
            multiResource.clear();
            for (int i = 0; i < xmlObjects.length; ++i) {
                multiResource.addResource();
                Iterator it = xmlObjectMapping.mappingsIt();
                while (it.hasNext()) {
                    Mapping m = (Mapping)it.next();
                    store |= m.getConverter().marshall(multiResource.currentResource(), xmlObjects[i], m, context);
                }
            }
            return store;
        }
        boolean store = false;
        Iterator it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            store |= m.getConverter().marshall(resource, rootXmlObject, m, context);
        }
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        if (xmlObjectMapping.getXmlContentMapping() == null) {
            return null;
        }
        XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
        return xmlContentMapping.getConverter().unmarshall(resource, xmlContentMapping, context);
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        SearchEngine searchEngine = context.getSearchEngine();
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)resourceMapping;
        ResourcePropertyMapping[] ids = resourceMapping.getIdMappings();
        if (id instanceof XmlObject) {
            XmlObject rootXmlObject = this.getActualXmlObject((XmlObject)id, xmlObjectMapping, context, idResource);
            if (xmlObjectMapping.getXPath() != null) {
                XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
                if (xmlObjects == null || xmlObjects.length == 0) {
                    throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
                }
                MultiResource multiResource = (MultiResource)idResource;
                multiResource.clear();
                for (int i = 0; i < xmlObjects.length; ++i) {
                    multiResource.addResource();
                    for (int j = 0; j < ids.length; ++j) {
                        ids[j].getConverter().marshall(multiResource.currentResource(), xmlObjects[i], ids[j], context);
                    }
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    ids[i].getConverter().marshall(idResource, rootXmlObject, ids[i], context);
                }
            }
        } else if (id instanceof Resource) {
            for (int i = 0; i < ids.length; ++i) {
                Resource rId = (Resource)id;
                idResource.addProperty(rId.getProperty(ids[i].getPath().getPath()));
            }
        } else if (id.getClass().isArray()) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load resource with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            if (Property.class.isAssignableFrom(id.getClass().getComponentType())) {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty((Property)Array.get(id, i));
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty(searchEngine.createProperty(ids[i].getPath().getPath(), Array.get(id, i).toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
                }
            }
        } else {
            if (ids.length != 1) {
                throw new ConversionException("Trying to load resource which has more than one id mappings with only one id value");
            }
            if (id instanceof Property) {
                idResource.addProperty((Property)id);
            } else {
                idResource.addProperty(searchEngine.createProperty(ids[0].getPath().getPath(), id.toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
            }
        }
        return true;
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported");
    }

    private XmlObject getActualXmlObject(XmlObject rootXmlObject, XmlObjectMapping xmlObjectMapping, MarshallingContext context, Resource resource) {
        if (rootXmlObject instanceof RawXmlObject) {
            Reader xml = ((RawXmlObject)rootXmlObject).getXml();
            XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
            XmlContentMappingConverter xmlContentMappingConverter = xmlContentMapping != null ? (XmlContentMappingConverter)xmlContentMapping.getConverter() : (XmlContentMappingConverter)context.getConverterLookup().lookupConverter("xmlContentMapping");
            rootXmlObject = xmlContentMappingConverter.getXmlContentConverter().fromXml(resource.getAlias(), xml);
        }
        return rootXmlObject;
    }
}

