/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic;

import java.text.Format;
import java.text.ParseException;
import java.util.Locale;
import org.compass.core.converter.ConversionException;

public class ThreadSafeFormat {
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient Format[] pool;
    private int nextAvailable = 0;
    private final Object mutex = new Object();
    private final FormatterFactory formatterFactory;

    public ThreadSafeFormat(int initialPoolSize, int maxPoolSize, FormatterFactory formatterFactory) {
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.formatterFactory = formatterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Object obj) {
        Format format = this.fetchFromPool();
        try {
            String string = format.format(obj);
            return string;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String date) throws ParseException {
        Format format = this.fetchFromPool();
        try {
            Object object = format.parseObject(date);
            return object;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Format fetchFromPool() {
        Format result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new Format[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(this.formatterFactory.create());
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new ConversionException("Interrupted whilst waiting for a free item in the pool", e);
                }
            }
            result = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (result == null) {
            result = this.formatterFactory.create();
            this.putInPool(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(Format format) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = format;
            this.mutex.notify();
        }
    }

    public static interface FormatterFactory {
        public void configure(String var1, Locale var2);

        public Format create();
    }
}

