/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config;

import java.util.Map;
import java.util.Properties;
import org.compass.core.config.CompassSettings;

public class RuntimeCompassSettings
extends CompassSettings {
    private CompassSettings globalSettings;
    private CompassSettings runtimeSettings;

    public RuntimeCompassSettings(CompassSettings globalSettings) {
        this.globalSettings = globalSettings;
        this.runtimeSettings = new CompassSettings();
    }

    public void addSettings(Properties settings) {
        this.runtimeSettings.addSettings(settings);
    }

    public void addSettings(CompassSettings settings) {
        this.runtimeSettings.addSettings(settings);
    }

    public CompassSettings copy() {
        RuntimeCompassSettings copy = new RuntimeCompassSettings(this.globalSettings);
        copy.runtimeSettings = this.runtimeSettings.copy();
        return copy;
    }

    public String getSetting(String setting) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return value;
        }
        return this.globalSettings.getSetting(setting);
    }

    public String getSetting(String setting, String defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return value;
        }
        return this.globalSettings.getSetting(setting, defaultValue);
    }

    public Map getSettingGroups(String settingPrefix) {
        Map group = this.runtimeSettings.getSettingGroups(settingPrefix);
        if (group.size() != 0) {
            return group;
        }
        return this.globalSettings.getSettingGroups(settingPrefix);
    }

    public float getSettingAsFloat(String setting, float defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsFloat(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsFloat(setting, defaultValue);
    }

    public int getSettingAsInt(String setting, int defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsInt(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsInt(setting, defaultValue);
    }

    public long getSettingAsLong(String setting, long defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsLong(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsLong(setting, defaultValue);
    }

    public boolean getSettingAsBoolean(String setting, boolean defaultValue) {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsBoolean(setting, defaultValue);
        }
        return this.globalSettings.getSettingAsBoolean(setting, defaultValue);
    }

    public Class getSettingAsClass(String setting, Class clazz) throws ClassNotFoundException {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsClass(setting, clazz);
        }
        return this.globalSettings.getSettingAsClass(setting, clazz);
    }

    public Class getSettingAsClass(String setting, Class clazz, ClassLoader classLoader) throws ClassNotFoundException {
        String value = this.runtimeSettings.getSetting(setting);
        if (value != null) {
            return this.runtimeSettings.getSettingAsClass(setting, clazz, classLoader);
        }
        return this.globalSettings.getSettingAsClass(setting, clazz, classLoader);
    }

    public CompassSettings setSetting(String setting, String value) {
        this.runtimeSettings.setSetting(setting, value);
        return this;
    }

    public CompassSettings setBooleanSetting(String setting, boolean value) {
        this.runtimeSettings.setBooleanSetting(setting, value);
        return this;
    }

    public CompassSettings setFloatSetting(String setting, float value) {
        this.runtimeSettings.setFloatSetting(setting, value);
        return this;
    }

    public CompassSettings setIntSetting(String setting, int value) {
        this.runtimeSettings.setIntSetting(setting, value);
        return this;
    }

    public CompassSettings setLongSetting(String setting, long value) {
        this.runtimeSettings.setLongSetting(setting, value);
        return this;
    }

    public CompassSettings setClassSetting(String setting, Class clazz) {
        this.runtimeSettings.setClassSetting(setting, clazz);
        return this;
    }

    public CompassSettings setGroupSettings(String settingPrefix, String groupName, String[] settings, String[] values) {
        this.runtimeSettings.setGroupSettings(settingPrefix, groupName, settings, values);
        return this;
    }

    public Object getRegistry(Object key) {
        return this.globalSettings.getRegistry(key);
    }

    public void setRegistry(Object key, Object value) {
        this.globalSettings.setRegistry(key, value);
    }

    public Object removeRegistry(Object key) {
        return this.globalSettings.removeRegistry(key);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Global [").append(this.globalSettings).append("]");
        sb.append("Runtime [").append(this.runtimeSettings).append("]");
        return sb.toString();
    }
}

