/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LuceneUtils;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.lucene.engine.LuceneSettings;

public class LuceneSegmentsMerger {
    private static final Log log = LogFactory.getLog((Class)LuceneSegmentsMerger.class);
    private Directory directory;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private Lock writeLock;
    private Vector filesToDeleteCS;
    private String newSegmentName;
    private Vector segmentsToDelete = new Vector();
    private boolean closeDir;
    private LuceneSettings luceneSettings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSegmentsMerger(Directory dir, boolean closeDir, LuceneSettings luceneSettings) throws IOException {
        this.closeDir = closeDir;
        this.directory = dir;
        this.luceneSettings = luceneSettings;
        Lock writeLock = this.directory.makeLock("write.lock");
        if (!writeLock.obtain(luceneSettings.getTransactionLockTimout())) {
            throw new IOException("Lock obtain failed: " + writeLock);
        }
        this.writeLock = writeLock;
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock"), luceneSettings.getTransactionCommitTimeout()){

                public Object doBody() throws IOException {
                    LuceneSegmentsMerger.this.segmentInfos.read(LuceneSegmentsMerger.this.directory);
                    return null;
                }
            }.run();
        }
    }

    public void mergeFromSegment(int fromSegment) throws IOException {
        this.newSegmentName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this.directory, this.newSegmentName);
        for (int i = fromSegment; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            SegmentReader reader = SegmentReader.get((SegmentInfo)si);
            merger.add((IndexReader)reader);
            this.segmentsToDelete.addElement(reader);
        }
        int mergedDocCount = merger.merge();
        merger.closeReaders();
        this.segmentInfos.setSize(fromSegment);
        this.segmentInfos.addElement((Object)new SegmentInfo(this.newSegmentName, mergedDocCount, this.directory));
        if (this.luceneSettings.isUseCompoundFile()) {
            this.filesToDeleteCS = merger.createCompoundFile(this.newSegmentName + ".tmp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            new Lock.With(this.directory.makeLock("commit.lock"), this.luceneSettings.getTransactionCommitTimeout()){

                public Object doBody() throws IOException {
                    if (LuceneSegmentsMerger.this.luceneSettings.isUseCompoundFile()) {
                        LuceneSegmentsMerger.this.directory.renameFile(LuceneSegmentsMerger.this.newSegmentName + ".tmp", LuceneSegmentsMerger.this.newSegmentName + ".cfs");
                    }
                    LuceneSegmentsMerger.this.segmentInfos.write(LuceneSegmentsMerger.this.directory);
                    return null;
                }
            }.run();
        }
        if (this.luceneSettings.isUseCompoundFile()) {
            LuceneUtils.deleteFiles(this.filesToDeleteCS, this.directory);
            this.filesToDeleteCS = null;
        }
        LuceneUtils.deleteSegments(this.segmentsToDelete, this.directory);
    }

    public void close() throws IOException {
        if (this.closeDir) {
            try {
                this.directory.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close directory, ignoring", (Throwable)ex);
            }
            this.directory = null;
        }
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }
}

