/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsrp4j.util;

import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v1.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v1.types.ClonePortlet;
import oasis.names.tc.wsrp.v1.types.CookieProtocol;
import oasis.names.tc.wsrp.v1.types.DestroyFailed;
import oasis.names.tc.wsrp.v1.types.DestroyPortlets;
import oasis.names.tc.wsrp.v1.types.DestroyPortletsResponse;
import oasis.names.tc.wsrp.v1.types.GetMarkup;
import oasis.names.tc.wsrp.v1.types.GetPortletDescription;
import oasis.names.tc.wsrp.v1.types.GetPortletProperties;
import oasis.names.tc.wsrp.v1.types.GetPortletPropertyDescription;
import oasis.names.tc.wsrp.v1.types.GetServiceDescription;
import oasis.names.tc.wsrp.v1.types.InitCookie;
import oasis.names.tc.wsrp.v1.types.InteractionParams;
import oasis.names.tc.wsrp.v1.types.MarkupContext;
import oasis.names.tc.wsrp.v1.types.MarkupParams;
import oasis.names.tc.wsrp.v1.types.MarkupResponse;
import oasis.names.tc.wsrp.v1.types.MissingParametersFault;
import oasis.names.tc.wsrp.v1.types.ModifyRegistration;
import oasis.names.tc.wsrp.v1.types.PerformBlockingInteraction;
import oasis.names.tc.wsrp.v1.types.PortletContext;
import oasis.names.tc.wsrp.v1.types.PortletDescription;
import oasis.names.tc.wsrp.v1.types.PortletDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PortletPropertyDescriptionResponse;
import oasis.names.tc.wsrp.v1.types.PropertyList;
import oasis.names.tc.wsrp.v1.types.RegistrationContext;
import oasis.names.tc.wsrp.v1.types.RegistrationData;
import oasis.names.tc.wsrp.v1.types.ReleaseSessions;
import oasis.names.tc.wsrp.v1.types.Resource;
import oasis.names.tc.wsrp.v1.types.ResourceList;
import oasis.names.tc.wsrp.v1.types.RuntimeContext;
import oasis.names.tc.wsrp.v1.types.ServiceDescription;
import oasis.names.tc.wsrp.v1.types.SessionContext;
import oasis.names.tc.wsrp.v1.types.SetPortletProperties;
import oasis.names.tc.wsrp.v1.types.Templates;
import oasis.names.tc.wsrp.v1.types.UpdateResponse;
import oasis.names.tc.wsrp.v1.types.UserContext;
import org.apache.wsrp4j.log.LogManager;
import org.apache.wsrp4j.log.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ParameterChecker {
    private Logger logger;
    static /* synthetic */ Class class$org$apache$wsrp4j$util$ParameterChecker;

    private final boolean isCheckEnabled() {
        return this.logger.isLogging(60);
    }

    public void check(GetServiceDescription request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof GetServiceDescription) {
                this.check(request.getRegistrationContext(), true);
            } else {
                this.throwMissingParametersFault("Input object is not from type GetServiceDescription or is null");
            }
        }
    }

    public void check(ModifyRegistration request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof ModifyRegistration) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getRegistrationData(), false);
            } else {
                this.throwMissingParametersFault("Input object is not from type ModifyRegistration or is null");
            }
        }
    }

    public void check(GetMarkup request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof GetMarkup) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getRuntimeContext(), false);
                this.check(request.getUserContext(), true);
                this.check(request.getMarkupParams(), false);
            } else {
                this.throwMissingParametersFault("Input object is not from type GetMarkup or is null");
            }
        }
    }

    public void check(PerformBlockingInteraction request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof PerformBlockingInteraction) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getRuntimeContext(), false);
                this.check(request.getUserContext(), true);
                this.check(request.getMarkupParams(), false);
                this.check(request.getInteractionParams(), false);
            } else {
                this.throwMissingParametersFault("Input object is not from type PerformBlockingInteraction or is null");
            }
        }
    }

    public void check(InitCookie request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof InitCookie) {
                this.check(request.getRegistrationContext(), true);
            } else {
                this.throwMissingParametersFault("Input object is not from type InitCookie or is null");
            }
        }
    }

    public void check(GetPortletDescription request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof GetPortletDescription) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getUserContext(), true);
            } else {
                this.throwMissingParametersFault("Input object is not from type GetPortletDescription or is null");
            }
        }
    }

    public void check(ClonePortlet request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof ClonePortlet) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getUserContext(), true);
            } else {
                this.throwMissingParametersFault("Input object is not a ClonePortlet or is null");
            }
        }
    }

    public void check(DestroyPortlets request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof DestroyPortlets) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletHandles(), false);
            } else {
                this.throwMissingParametersFault("Input object is not a DestroyPortlets or is null");
            }
        }
    }

    public void check(SetPortletProperties request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof SetPortletProperties) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getUserContext(), true);
                this.check(request.getPropertyList(), false);
            } else {
                this.throwMissingParametersFault("Input object is not a SetPortletProperties or is null");
            }
        }
    }

    public void check(GetPortletProperties request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof GetPortletProperties) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getUserContext(), true);
                this.check(request.getNames(), true);
            } else {
                this.throwMissingParametersFault("Input object is not a GetPortletProperties or is null");
            }
        }
    }

    public void check(GetPortletPropertyDescription request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof GetPortletPropertyDescription) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getPortletContext(), false);
                this.check(request.getUserContext(), true);
            } else {
                this.throwMissingParametersFault("Input object is not a GetPortletPropertyDescription or is null");
            }
        }
    }

    public void check(ReleaseSessions request) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (request instanceof ReleaseSessions) {
                this.check(request.getRegistrationContext(), true);
                this.check(request.getSessionIDs(), false);
            } else {
                this.throwMissingParametersFault("Input object is not a ReleaseSession or is null");
            }
        }
    }

    public void check(ServiceDescription response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof ServiceDescription) {
                if (response == null) {
                    if (response.getOfferedPortlets() != null) {
                        PortletDescription[] portletDesc = response.getOfferedPortlets();
                        int i = 0;
                        while (i < portletDesc.length) {
                            this.check(portletDesc[i]);
                            ++i;
                        }
                    } else if (response.getRequiresInitCookie() != null) {
                        this.check(response.getRequiresInitCookie(), true);
                    } else if (response.getResourceList() != null) {
                        this.check(response.getResourceList(), true);
                    } else {
                        this.throwMissingParametersFault("No valid service description.");
                    }
                }
            } else {
                this.throwMissingParametersFault("No valid service description response found.");
            }
        }
    }

    public void check(BlockingInteractionResponse response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof BlockingInteractionResponse) {
                if (response.getUpdateResponse() != null && response.getRedirectURL() == null) {
                    this.check(response.getUpdateResponse());
                } else if (response.getRedirectURL() == null || response.getUpdateResponse() != null) {
                    this.throwMissingParametersFault("No valid blocking interaction response. UpdateResponseand redirect url are mutually exclusive");
                }
            } else {
                this.throwMissingParametersFault("No valid blocking interaction response found.");
            }
        }
    }

    private final void check(UpdateResponse response) throws MissingParametersFault {
        if (response instanceof UpdateResponse) {
            this.check(response.getSessionContext(), true);
            this.check(response.getPortletContext(), true);
            this.check(response.getMarkupContext(), true);
        } else {
            this.throwMissingParametersFault("No valid update response found.");
        }
    }

    public void check(MarkupResponse response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof MarkupResponse) {
                this.check(response.getMarkupContext(), false);
                this.check(response.getSessionContext(), true);
            } else {
                this.throwMissingParametersFault("No valid markup response found.");
            }
        }
    }

    public void check(PortletDescriptionResponse response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof PortletDescriptionResponse) {
                this.check(response.getPortletDescription());
                this.check(response.getResourceList(), true);
            } else {
                this.throwMissingParametersFault("No valid PortletDescriptionResponse response found.");
            }
        }
    }

    public void check(PortletPropertyDescriptionResponse response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof PortletPropertyDescriptionResponse) {
                this.check(response.getResourceList(), true);
            } else {
                this.throwMissingParametersFault("No valid PortletPropertyDescriptionResponse response found.");
            }
        }
    }

    public void check(DestroyPortletsResponse response) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (response instanceof DestroyPortletsResponse) {
                this.check(response.getDestroyFailed(), true);
            } else {
                this.throwMissingParametersFault("No valid PortletDescriptionResponse response found.");
            }
        }
    }

    public void check(PortletDescription element) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (element instanceof PortletDescription) {
                if (element.getPortletHandle() == null) {
                    this.throwMissingParametersFault("A portlet handle has to be set in the portlet description.");
                }
                if (element.getMarkupTypes() == null) {
                    this.throwMissingParametersFault("Markup types have to be defined in the portlet description.");
                }
            } else {
                this.throwMissingParametersFault("No valid portlet description found.");
            }
        }
    }

    public void check(Templates element) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (element instanceof Templates) {
                if (element.getDefaultTemplate() == null) {
                    this.throwMissingParametersFault("DefaultTemplate has not been set!");
                }
                if (element.getSecureDefaultTemplate() == null) {
                    this.throwMissingParametersFault("SecureDefaultTemplate Template has not been set!");
                }
            } else {
                this.throwMissingParametersFault("Consumer has to provide templates!");
            }
        }
    }

    private final void check(SessionContext context, boolean nillable) throws MissingParametersFault {
        if (context != null) {
            if (context.getSessionID() == null) {
                this.throwMissingParametersFault("No valid session context found. No session handle set.");
            }
            if (context.getExpires() == 0) {
                this.throwMissingParametersFault("No valid session context found. No session expire set.");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("No valid session context found.");
        }
    }

    private final void check(MarkupContext context, boolean nillable) throws MissingParametersFault {
        if (context != null) {
            boolean bMarkupBinary = false;
            boolean bMarkupString = false;
            if (context.getMarkupBinary() != null) {
                bMarkupBinary = true;
            }
            if (context.getMarkupString() != null) {
                bMarkupString = true;
            }
            if (bMarkupBinary != bMarkupString) {
                if (context.getMimeType() == null) {
                    this.throwMissingParametersFault("MimeType not set in MarkupContext.");
                } else if (context.getLocale() == null) {
                    this.throwMissingParametersFault("Locale not set in MarkupContext.");
                }
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("No valid markup context found.");
        }
    }

    public void check(PropertyList propertyList, boolean nillable) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (propertyList != null) {
                if (propertyList.getProperties() == null) {
                    this.throwMissingParametersFault("PropertyList[] in PropertyList is null");
                }
            } else if (!nillable) {
                this.throwMissingParametersFault("PropertyList object is null");
            }
        }
    }

    public void check(RegistrationData registrationData, boolean nillable) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (registrationData != null) {
                if (registrationData.getConsumerName() == null) {
                    this.throwMissingParametersFault("ConsumerName in RegistrationData is null");
                }
                if (registrationData.getConsumerAgent() == null) {
                    this.throwMissingParametersFault("ConsumerAgent in RegistrationData is null");
                }
            } else if (!nillable) {
                this.throwMissingParametersFault("RegistrationData object is null");
            }
        }
    }

    private final void check(String[] array, boolean nillable) throws MissingParametersFault {
        if (array != null) {
            if (array.length == 0) {
                this.throwMissingParametersFault("String[] array length is zero (0)");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("String array[] object is null");
        }
    }

    private final void check(InteractionParams interactionParams, boolean nillable) throws MissingParametersFault {
        if (interactionParams != null) {
            if (interactionParams.getPortletStateChange() == null) {
                this.throwMissingParametersFault("PortletStateChange in InteractionParams is null");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("InteractionParams object is null");
        }
    }

    public void check(RegistrationContext registrationContext, boolean nillable) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (registrationContext != null) {
                if (registrationContext.getRegistrationHandle() == null) {
                    this.throwMissingParametersFault("RegistrationHandle in RegistrationContext is null");
                }
            } else if (!nillable) {
                this.throwMissingParametersFault("RegistrationContext object is null");
            }
        }
    }

    public void check(PortletContext portletContext, boolean nillable) throws MissingParametersFault {
        if (this.isCheckEnabled()) {
            if (portletContext != null) {
                if (portletContext.getPortletHandle() == null) {
                    this.throwMissingParametersFault("PortletHandle in PortletContext is null");
                }
            } else if (!nillable) {
                this.throwMissingParametersFault("PortletContext object is null");
            }
        }
    }

    private final void check(RuntimeContext runtimeContext, boolean nillable) throws MissingParametersFault {
        if (runtimeContext != null) {
            if (runtimeContext.getUserAuthentication() == null) {
                this.throwMissingParametersFault("UserAuthentication in RuntimeContext is null");
            }
            runtimeContext.getPortletInstanceKey();
        } else if (!nillable) {
            this.throwMissingParametersFault("RuntimeContext object is null");
        }
    }

    private final void check(DestroyFailed[] destroyFailedArray, boolean nillable) throws MissingParametersFault {
        if (destroyFailedArray != null) {
            if (destroyFailedArray.length > 0) {
                int x = 0;
                while (x < destroyFailedArray.length) {
                    if (destroyFailedArray[x].getPortletHandle() == null) {
                        this.throwMissingParametersFault("Missing Portlet handle in DestroyFailed object.");
                    }
                    if (destroyFailedArray[x].getReason() == null) {
                        this.throwMissingParametersFault("Missing Reason in DestroyFailed object.");
                    }
                    ++x;
                }
            } else {
                this.throwMissingParametersFault("DestroyFailedArray length is zero (0).");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("DestroyFailed[] object is null");
        }
    }

    private final void check(UserContext userContext, boolean nillable) throws MissingParametersFault {
        if (userContext != null) {
            if (userContext.getUserContextKey() == null) {
                this.throwMissingParametersFault("UserContextKey in UserContext is null");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("UserContext object is null");
        }
    }

    private final void check(ResourceList resourceList, boolean nillable) throws MissingParametersFault {
        if (resourceList != null) {
            if (resourceList.getResources() == null) {
                this.throwMissingParametersFault("Resource[] is null");
            } else {
                Resource[] resourceArray = resourceList.getResources();
                if (resourceArray.length < 1) {
                    this.throwMissingParametersFault("ResourceArray length is zero (0).");
                }
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("ResourceList object is null");
        }
    }

    private final void check(CookieProtocol requiresInit, boolean nillable) throws MissingParametersFault {
        if (requiresInit != null) {
            if (!(requiresInit.toString().equals("none") || requiresInit.toString().equals("perGroup") || requiresInit.toString().equals("perUser"))) {
                this.throwMissingParametersFault("Invalid value (" + requiresInit.toString() + ") of CookieProtocol object.");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("RequiresInitCookie object is null");
        }
    }

    private final void check(MarkupParams markupParams, boolean nillable) throws MissingParametersFault {
        if (markupParams != null) {
            if (markupParams.getClientData() == null) {
                this.throwMissingParametersFault("ClientData in MarkupParams is null");
            }
            if (markupParams.getLocales() == null) {
                this.throwMissingParametersFault("Locales in MarkupParams is null");
            }
            if (markupParams.getMimeTypes() == null) {
                this.throwMissingParametersFault("MimeTypes in MarkupParams is null");
            }
            if (markupParams.getMode() == null) {
                this.throwMissingParametersFault("Mode in MarkupParams is null");
            }
            if (markupParams.getWindowState() == null) {
                this.throwMissingParametersFault("WindowState in MarkupParams is null");
            }
        } else if (!nillable) {
            this.throwMissingParametersFault("MarkupParams object is null");
        }
    }

    private final void throwMissingParametersFault(String msg) throws MissingParametersFault {
        MissingParametersFault e = new MissingParametersFault();
        e.setFaultCode(new QName("urn:oasis:names:tc:wsrp:v1:types", "Interface.MissingParameters"));
        e.setFaultString(msg);
        throw e;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        LogManager logManager = LogManager.getLogManager();
        Class clazz = class$org$apache$wsrp4j$util$ParameterChecker;
        if (clazz == null) {
            clazz = class$org$apache$wsrp4j$util$ParameterChecker = ParameterChecker.class("[Lorg.apache.wsrp4j.util.ParameterChecker;", false);
        }
        this.logger = logManager.getLogger(clazz);
    }

    public ParameterChecker() {
        this.this();
    }
}

