/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.MyfacesStateManager;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared_impl.renderkit.ViewSequenceUtils;
import org.apache.myfaces.shared_impl.util.MyFacesObjectInputStream;

public class JspStateManagerImpl
extends MyfacesStateManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$application$jsp$JspStateManagerImpl == null ? (class$org$apache$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("org.apache.myfaces.application.jsp.JspStateManagerImpl")) : class$org$apache$myfaces$application$jsp$JspStateManagerImpl));
    private static final String SERIALIZED_VIEW_SESSION_ATTR = (class$org$apache$myfaces$application$jsp$JspStateManagerImpl == null ? (class$org$apache$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("org.apache.myfaces.application.jsp.JspStateManagerImpl")) : class$org$apache$myfaces$application$jsp$JspStateManagerImpl).getName() + ".SERIALIZED_VIEW";
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = (class$org$apache$myfaces$application$jsp$JspStateManagerImpl == null ? (class$org$apache$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("org.apache.myfaces.application.jsp.JspStateManagerImpl")) : class$org$apache$myfaces$application$jsp$JspStateManagerImpl).getName() + ".SERIALIZED_VIEW";
    private static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = (class$org$apache$myfaces$application$jsp$JspStateManagerImpl == null ? (class$org$apache$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("org.apache.myfaces.application.jsp.JspStateManagerImpl")) : class$org$apache$myfaces$application$jsp$JspStateManagerImpl).getName() + ".RESTORED_SERIALIZED_VIEW";
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    private static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    private static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    private static final int UNCOMPRESSED_FLAG = 0;
    private static final int COMPRESSED_FLAG = 1;
    private RenderKitFactory _renderKitFactory = null;
    static /* synthetic */ Class class$org$apache$myfaces$application$jsp$JspStateManagerImpl;

    public JspStateManagerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New JspStateManagerImpl instance created");
        }
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getComponentStateToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getComponentStateToSave");
        }
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        TreeStructureManager tsm = new TreeStructureManager();
        Object retVal = tsm.buildTreeStructureToSave(viewRoot);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    protected void restoreComponentState(FacesContext facesContext, UIViewRoot uiViewRoot, String renderKitId) {
        Object serializedComponentStates;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreComponentState");
        }
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            serializedComponentStates = responseStateManager.getComponentStateToRestore(facesContext);
            if (serializedComponentStates == null) {
                log.error((Object)"No serialized component state found in client request!");
                uiViewRoot.setViewId(null);
                return;
            }
        } else {
            String sequenceStr;
            String viewId = uiViewRoot.getViewId();
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext, viewId, sequenceStr = this.getSequenceString(facesContext, renderKitId, viewId));
            if (serializedView == null) {
                log.error((Object)"No serialized view found in server session!");
                uiViewRoot.setViewId(null);
                return;
            }
            serializedComponentStates = serializedView.getState();
            if (serializedComponentStates == null) {
                log.error((Object)"No serialized component state found in server session!");
                return;
            }
        }
        if (uiViewRoot.getRenderKitId() == null) {
            uiViewRoot.setRenderKitId(renderKitId);
        }
        uiViewRoot.processRestoreState(facesContext, serializedComponentStates);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreComponentState");
        }
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreTreeStructure");
        }
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = rk.getResponseStateManager();
            Object treeStructure = responseStateManager.getTreeStructureToRestore(facesContext, viewId);
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No tree structure state found in client request");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)treeStructure);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from client request");
            }
        } else {
            String sequenceStr = this.getSequenceString(facesContext, renderKitId, viewId);
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext, viewId, sequenceStr);
            if (serializedView == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No serialized view found in server session!");
                }
                return null;
            }
            Object treeStructure = serializedView.getStructure();
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No tree structure state found in server session, former UIViewRoot must have been transient");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)serializedView.getStructure());
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from server session");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreTreeStructure");
        }
        return uiViewRoot;
    }

    private String getSequenceString(FacesContext facesContext, String renderKitId, String viewId) {
        RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
        ResponseStateManager responseStateManager = rk.getResponseStateManager();
        String sequenceStr = (String)responseStateManager.getTreeStructureToRestore(facesContext, viewId);
        return sequenceStr;
    }

    public UIViewRoot restoreView(FacesContext facescontext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreView");
        }
        if ((uiViewRoot = this.restoreTreeStructure(facescontext, viewId, renderKitId)) != null) {
            uiViewRoot.setViewId(viewId);
            this.restoreComponentState(facescontext, uiViewRoot, renderKitId);
            String restoredViewId = uiViewRoot.getViewId();
            if (restoredViewId == null || !restoredViewId.equals(viewId)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Exiting restoreView - restored view is null.");
                }
                return null;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreView");
        }
        return uiViewRoot;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        ExternalContext externalContext;
        StateManager.SerializedView serializedView;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering saveSerializedView");
        }
        JspStateManagerImpl.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing saveSerializedView - Checked for duplicate Ids");
        }
        if ((serializedView = (StateManager.SerializedView)(externalContext = facesContext.getExternalContext()).getRequestMap().get(SERIALIZED_VIEW_REQUEST_ATTR)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - create new serialized view");
            }
            Object treeStruct = this.getTreeStructureToSave(facesContext);
            Object compStates = this.getComponentStateToSave(facesContext);
            serializedView = new StateManager.SerializedView((StateManager)this, treeStruct, compStates);
            externalContext.getRequestMap().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - new serialized view created");
            }
        }
        if (!this.isSavingStateInClient(facesContext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - server-side state saving - save state");
            }
            this.saveSerializedViewInServletSession(facesContext, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting saveSerializedView - server-side state saving - saved state");
            }
            Integer sequence = ViewSequenceUtils.getViewSequence(facesContext);
            return new StateManager.SerializedView((StateManager)this, (Object)sequence.toString(), null);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting saveSerializedView - client-side state saving");
        }
        return serializedView;
    }

    private static void checkForDuplicateIds(FacesContext context, UIComponent component, Set ids) {
        String id = component.getId();
        if (id != null && !ids.add(id)) {
            throw new IllegalStateException("Client-id : " + id + " is duplicated in the faces tree. Component : " + component.getClientId(context) + ", path: " + JspStateManagerImpl.getPathToComponent(component));
        }
        Iterator it = component.getFacetsAndChildren();
        boolean namingContainer = component instanceof NamingContainer;
        while (it.hasNext()) {
            UIComponent kid = (UIComponent)it.next();
            if (namingContainer) {
                JspStateManagerImpl.checkForDuplicateIds(context, kid, new HashSet());
                continue;
            }
            JspStateManagerImpl.checkForDuplicateIds(context, kid, ids);
        }
    }

    private static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        JspStateManagerImpl.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        if (component != null) {
            JspStateManagerImpl.getPathToComponent(component.getParent(), buf);
        }
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering writeState");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing writeState - either client-side (full state) or server-side (partial information; e.g. sequence)");
        }
        if (serializedView != null) {
            UIViewRoot uiViewRoot = facesContext.getViewRoot();
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
            renderKit.getResponseStateManager().writeState(facesContext, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting writeState");
            }
        }
    }

    public void writeStateAsUrlParams(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering writeStateAsUrlParams");
        }
        if (this.isSavingStateInClient(facesContext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing writeStateAsUrlParams - client-side state saving writing state");
            }
            UIViewRoot uiViewRoot = facesContext.getViewRoot();
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            if (responseStateManager instanceof MyfacesResponseStateManager) {
                ((MyfacesResponseStateManager)responseStateManager).writeStateAsUrlParams(facesContext, serializedView);
            } else {
                log.error((Object)("ResponseStateManager of render kit " + uiViewRoot.getRenderKitId() + " is no MyfacesResponseStateManager and does not support saving state in url parameters."));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting writeStateAsUrlParams");
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, StateManager.SerializedView serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = new SerializedViewCollection();
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        viewCollection.add(context, this.serializeView(context, serializedView));
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected StateManager.SerializedView getSerializedViewFromServletSession(FacesContext context, String viewId, String sequenceStr) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        StateManager.SerializedView serializedView = null;
        if (requestMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = (StateManager.SerializedView)requestMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null) {
                Object state;
                Integer sequence = null;
                sequence = sequenceStr == null ? ViewSequenceUtils.getCurrentSequence(context) : new Integer(sequenceStr);
                if (sequence != null && (state = viewCollection.get(sequence, viewId)) != null) {
                    serializedView = this.deserializeView(state);
                }
            }
            requestMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            ViewSequenceUtils.nextViewSequence(context);
        }
        return serializedView;
    }

    protected Object serializeView(FacesContext context, StateManager.SerializedView serializedView) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(serializedView.getStructure());
                out.writeObject(serializedView.getState());
                out.close();
                baos.close();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Exiting serializeView - serialized. Bytes : " + baos.size()));
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.error((Object)("Exiting serializeView - Could not serialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting serializeView - do not serialize state in session.");
        }
        return new Object[]{serializedView.getStructure(), serializedView.getState()};
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = new Boolean(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = new Boolean(value);
        }
        return compress;
    }

    protected StateManager.SerializedView deserializeView(Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering deserializeView");
        }
        if (state instanceof byte[]) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length));
            }
            try {
                ByteArrayInputStream bais;
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream in = new MyFacesObjectInputStream(is);
                return new StateManager.SerializedView((StateManager)this, in.readObject(), in.readObject());
            }
            catch (IOException e) {
                log.error((Object)("Exiting deserializeView - Could not deserialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Exiting deserializeView - Could not deserialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        if (state instanceof Object[]) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting deserializeView - state not serialized.");
            }
            Object[] value = (Object[])state;
            return new StateManager.SerializedView((StateManager)this, value[0], value[1]);
        }
        if (state == null) {
            log.error((Object)"Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.error((Object)("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass()));
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class SerializedViewKey
    implements Serializable {
        private static final long serialVersionUID = -1170697124386063642L;
        private final String _viewId;
        private final Integer _sequenceId;

        public SerializedViewKey(String viewId, Integer sequence) {
            this._sequenceId = sequence;
            this._viewId = viewId;
        }

        public SerializedViewKey(FacesContext context) {
            this._sequenceId = ViewSequenceUtils.getViewSequence(context);
            this._viewId = context.getViewRoot().getViewId();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof SerializedViewKey) {
                SerializedViewKey other = (SerializedViewKey)obj;
                return new EqualsBuilder().append((Object)other._viewId, (Object)this._viewId).append((Object)other._sequenceId, (Object)this._sequenceId).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this._viewId).append((Object)this._sequenceId).toHashCode();
        }
    }

    protected static class SerializedViewCollection
    implements Serializable {
        private static final long serialVersionUID = -3734849062185115847L;
        private final List _keys = new ArrayList(20);
        private final Map _serializedViews = new HashMap();
        private transient Map _oldSerializedViews = null;

        protected SerializedViewCollection() {
        }

        public synchronized void add(FacesContext context, Object state) {
            SerializedViewKey key = new SerializedViewKey(context);
            this._serializedViews.put(key, state);
            while (this._keys.remove(key)) {
            }
            this._keys.add(key);
            int views = this.getNumberOfViewsInSession(context);
            while (this._keys.size() > views) {
                key = this._keys.remove(0);
                Object oldView = this._serializedViews.remove(key);
                if (oldView == null) continue;
                this.getOldSerializedViewsMap().put(key, oldView);
            }
        }

        protected int getNumberOfViewsInSession(FacesContext context) {
            String value = context.getExternalContext().getInitParameter(JspStateManagerImpl.NUMBER_OF_VIEWS_IN_SESSION_PARAM);
            int views = 20;
            if (value != null) {
                try {
                    views = Integer.parseInt(value);
                    if (views <= 0) {
                        log.error((Object)"Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                        views = 20;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage()), e);
                }
            }
            return views;
        }

        protected Map getOldSerializedViewsMap() {
            if (this._oldSerializedViews == null) {
                this._oldSerializedViews = new ReferenceMap(2, 2, true);
            }
            return this._oldSerializedViews;
        }

        public Object get(Integer sequence, String viewId) {
            SerializedViewKey key = new SerializedViewKey(viewId, sequence);
            Object value = this._serializedViews.get(key);
            if (value == null) {
                value = this.getOldSerializedViewsMap().get(key);
            }
            return value;
        }
    }
}

