/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.richfaces.resource.ResourceFactoryImpl;

public abstract class LazyLoadingObject<T> {
    private Class<?>[] interfaces;
    private AtomicReference<T> reference = new AtomicReference<Object>(null);

    public LazyLoadingObject(Class<?> ... interfaces) {
        this.interfaces = interfaces;
    }

    protected abstract T loadData();

    public T getLazilyLoaded() {
        return (T)Proxy.newProxyInstance(ResourceFactoryImpl.class.getClassLoader(), this.interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (LazyLoadingObject.this.reference.get() == null) {
                    Object result = LazyLoadingObject.this.loadData();
                    LazyLoadingObject.this.reference.compareAndSet(null, result);
                }
                return method.invoke(LazyLoadingObject.this.reference.get(), args);
            }
        });
    }
}

