/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.applets.editor;

import com.liferay.applets.editor.Lexer;
import com.liferay.applets.editor.Token;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class XmlLexer
extends Lexer {
    private static final SimpleAttributeSet STYLE_SCRIPT = (SimpleAttributeSet)STYLE_TEXT.clone();
    private static final SimpleAttributeSet STYLE_ELEMENT;
    private static final SimpleAttributeSet STYLE_ATTR_NAME;
    private static final SimpleAttributeSet STYLE_ATTR_VALUE;
    private static final SimpleAttributeSet STYLE_COMMENT;

    public void parse(String str) {
        this._tokens = new ArrayList();
        for (int ii = 0; ii < str.length(); ++ii) {
            int end;
            int beg;
            String substr = str.substring(ii);
            if (substr.charAt(0) != '<') {
                int beg2 = ii;
                int end2 = str.indexOf("<", ii + 1);
                end2 = end2 == -1 ? str.length() - 1 : --end2;
                this._tokens.add(new Token(beg2, end2, STYLE_TEXT));
            } else if (substr.startsWith("<!--")) {
                this._tokens.add(this.getBracketed(str, ii, "<!--", "-->", STYLE_COMMENT));
            } else if (this.isScriptTag(substr)) {
                ArrayList nest = new ArrayList();
                beg = ii;
                end = this.extractNest(str, ii + 1, nest);
                this._tokens.add(new Token(beg, end, STYLE_ELEMENT));
                this._tokens.addAll(nest);
                ii = ((Token)this._tokens.get(this._tokens.size() - 1)).getEnd();
                if (!str.substring(ii - 1).startsWith("/>")) {
                    int closeTag = str.toLowerCase().indexOf("</script", ii + 1);
                    if (closeTag == -1) {
                        if (ii + 1 != str.length() - 1) {
                            this._tokens.add(new Token(ii + 1, str.length() - 1, STYLE_TEXT));
                        }
                        ii = str.length() - 1;
                    } else {
                        this._tokens.add(new Token(ii + 1, closeTag - 1, STYLE_SCRIPT));
                        nest.clear();
                        int closeTagEnd = this.extractNest(str, closeTag + 1, nest);
                        this._tokens.add(new Token(closeTag, closeTagEnd, STYLE_ELEMENT));
                        this._tokens.addAll(nest);
                    }
                }
            } else {
                ArrayList nest = new ArrayList();
                beg = ii;
                end = this.extractNest(str, ii + 1, nest);
                this._tokens.add(new Token(beg, end, STYLE_ELEMENT));
                this._tokens.addAll(nest);
            }
            ii = ((Token)this._tokens.get(this._tokens.size() - 1)).getEnd();
        }
    }

    private int extractNest(String str, int start, List nest) {
        Token tail = null;
        int absEnd = str.indexOf(">", start);
        if (absEnd == -1) {
            absEnd = str.length() - 1;
        } else {
            tail = str.charAt(absEnd - 1) == '?' || str.charAt(absEnd - 1) == '/' ? new Token(--absEnd, absEnd + 1, STYLE_ELEMENT) : new Token(absEnd, absEnd, STYLE_ELEMENT);
            --absEnd;
        }
        boolean hasAtt = false;
        ++start;
        while (start <= absEnd) {
            if (Character.isWhitespace(str.charAt(start))) {
                hasAtt = true;
                break;
            }
            ++start;
        }
        if (hasAtt) {
            int beg = start++;
            int end = -1;
            while (start <= absEnd) {
                int valEnd;
                int valBeg;
                if (str.charAt(start) == '\"') {
                    end = start - 1;
                    nest.add(new Token(beg, end, STYLE_ATTR_NAME));
                    valBeg = start++;
                    valEnd = -1;
                    while (start <= absEnd) {
                        if (str.charAt(start) == '\"') {
                            valEnd = start;
                            nest.add(new Token(valBeg, valEnd, STYLE_ATTR_VALUE));
                            break;
                        }
                        ++start;
                    }
                    if (valEnd == -1) {
                        nest.add(new Token(valBeg, absEnd, STYLE_ATTR_VALUE));
                    } else {
                        beg = start + 1;
                        end = -1;
                    }
                } else if (str.charAt(start) == '\'') {
                    end = start - 1;
                    nest.add(new Token(beg, end, STYLE_ATTR_NAME));
                    valBeg = start++;
                    valEnd = -1;
                    while (start <= absEnd) {
                        if (str.charAt(start) == '\'') {
                            valEnd = start;
                            nest.add(new Token(valBeg, valEnd, STYLE_ATTR_VALUE));
                            break;
                        }
                        ++start;
                    }
                    if (valEnd == -1) {
                        nest.add(new Token(valBeg, absEnd, STYLE_ATTR_VALUE));
                    } else {
                        beg = start + 1;
                        end = -1;
                    }
                }
                ++start;
            }
            if (end == -1) {
                nest.add(new Token(beg, absEnd, STYLE_ATTR_NAME));
            }
        }
        if (tail != null) {
            nest.add(tail);
        }
        if (nest.size() > 0) {
            absEnd = ((Token)nest.get(0)).getBeg() - 1;
        }
        return absEnd;
    }

    private boolean isScriptTag(String str) {
        return !(str.length() < "<script".length() || str.charAt(0) != '<' || str.charAt(1) != 's' && str.charAt(1) != 'S' || str.charAt(2) != 'c' && str.charAt(2) != 'C' || str.charAt(3) != 'r' && str.charAt(3) != 'R' || str.charAt(4) != 'i' && str.charAt(4) != 'I' || str.charAt(5) != 'p' && str.charAt(5) != 'P' || str.charAt(6) != 't' && str.charAt(6) != 'T');
    }

    static {
        StyleConstants.setForeground(STYLE_SCRIPT, Color.orange.darker());
        StyleConstants.setItalic(STYLE_SCRIPT, true);
        STYLE_ELEMENT = (SimpleAttributeSet)STYLE_TEXT.clone();
        StyleConstants.setForeground(STYLE_ELEMENT, Color.green.darker().darker());
        StyleConstants.setBold(STYLE_ELEMENT, true);
        STYLE_ATTR_NAME = (SimpleAttributeSet)STYLE_TEXT.clone();
        StyleConstants.setForeground(STYLE_ATTR_NAME, Color.red.darker());
        STYLE_ATTR_VALUE = (SimpleAttributeSet)STYLE_TEXT.clone();
        StyleConstants.setForeground(STYLE_ATTR_VALUE, Color.blue);
        STYLE_COMMENT = (SimpleAttributeSet)STYLE_TEXT.clone();
        StyleConstants.setForeground(STYLE_COMMENT, Color.gray);
        StyleConstants.setItalic(STYLE_COMMENT, true);
    }
}

