/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.applets.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SizeSequence;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumberView
extends JComponent {
    private static final int WIDTH_TEMPLATE = 99999;
    private FontMetrics _viewFontMetrics;
    private int _margin;
    private int _maxNumberWidth;
    private int _componentWidth;
    private int _textTopInset;
    private int _textFontAscent;
    private int _textFontHeight;
    private JTextComponent _textComponent;
    private SizeSequence _sizes;
    private int _startLine = 0;
    private boolean _structureChanged = true;

    public LineNumberView(JTextComponent tc) {
        if (tc == null) {
            throw new IllegalArgumentException("JTextComponent param cannot be null");
        }
        this._textComponent = tc;
        this.setFont(new Font("MONOSPACED", 0, 12));
        this.setBackground(new Color(240, 240, 255));
        this.setForeground(new Color(128, 128, 255));
        UpdateHandler handler = new UpdateHandler();
        this._textComponent.getDocument().addDocumentListener(handler);
        this._textComponent.addPropertyChangeListener(handler);
        this._textComponent.addComponentListener(handler);
    }

    private void viewChanged(int startLine, boolean structureChanged) {
        this._startLine = startLine;
        this._structureChanged = structureChanged;
        this.revalidate();
        this.repaint();
    }

    private void updateSizes() {
        if (this._startLine < 0) {
            return;
        }
        if (this._structureChanged) {
            int count = this.getAdjustedLineCount();
            this._sizes = new SizeSequence(count);
            for (int i = 0; i < count; ++i) {
                this._sizes.setSize(i, this.getLineHeight(i));
            }
            this._structureChanged = false;
        } else {
            this._sizes.setSize(this._startLine, this.getLineHeight(this._startLine));
        }
        this._startLine = -1;
    }

    private int getAdjustedLineCount() {
        int n;
        Element map = this._textComponent.getDocument().getDefaultRootElement();
        Element lastLine = map.getElement((n = map.getElementCount()) - 1);
        if (lastLine.getEndOffset() - lastLine.getStartOffset() > 1) {
            return n;
        }
        return n - 1;
    }

    private int getLineHeight(int index) {
        int lastPos = this._sizes.getPosition(index) + this._textTopInset;
        int height = this._textFontHeight;
        try {
            Element map = this._textComponent.getDocument().getDefaultRootElement();
            int lastChar = map.getElement(index).getEndOffset() - 1;
            Rectangle r = this._textComponent.modelToView(lastChar);
            if (r != null) {
                height = r.y - lastPos + r.height;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return height;
    }

    private void updateCachedMetrics() {
        Font textFont = this._textComponent.getFont();
        FontMetrics fm = this.getFontMetrics(textFont);
        this._textFontHeight = fm.getHeight();
        this._textFontAscent = fm.getAscent();
        this._textTopInset = this._textComponent.getInsets().top;
        this._margin = this._textComponent.getInsets().left;
        Font viewFont = this.getFont();
        boolean newViewFont = false;
        if (viewFont == null) {
            viewFont = textFont;
            newViewFont = true;
        }
        this._viewFontMetrics = this.getFontMetrics(viewFont);
        this._maxNumberWidth = this._viewFontMetrics.stringWidth(String.valueOf(99999));
        this._componentWidth = 2 * this._margin + this._maxNumberWidth;
        if (newViewFont) {
            super.setFont(viewFont);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateCachedMetrics();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._componentWidth, this._textComponent.getHeight());
    }

    public void paintComponent(Graphics g) {
        this.updateSizes();
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeground());
        int base = clip.y - this._textTopInset;
        int first = this._sizes.getIndex(base);
        int last = this._sizes.getIndex(base + clip.height);
        for (int i = first; i <= last; ++i) {
            String text = String.valueOf(i + 1);
            int x = this._margin + this._maxNumberWidth - this._viewFontMetrics.stringWidth(text);
            int y = this._sizes.getPosition(i) + this._textFontAscent + this._textTopInset;
            g.drawString(text, x, y);
        }
    }

    class UpdateHandler
    extends ComponentAdapter
    implements PropertyChangeListener,
    DocumentListener {
        UpdateHandler() {
        }

        public void componentResized(ComponentEvent evt) {
            LineNumberView.this.viewChanged(0, true);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            if ("document".equals(propertyName)) {
                if (oldValue != null && oldValue instanceof Document) {
                    ((Document)oldValue).removeDocumentListener(this);
                }
                if (newValue != null && newValue instanceof Document) {
                    ((Document)newValue).addDocumentListener(this);
                }
            }
            LineNumberView.this.updateCachedMetrics();
            LineNumberView.this.viewChanged(0, true);
        }

        public void insertUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        public void removeUpdate(DocumentEvent evt) {
            this.update(evt);
        }

        public void changedUpdate(DocumentEvent evt) {
        }

        private void update(DocumentEvent evt) {
            Element map = LineNumberView.this._textComponent.getDocument().getDefaultRootElement();
            int line = map.getElementIndex(evt.getOffset());
            DocumentEvent.ElementChange ec = evt.getChange(map);
            LineNumberView.this.viewChanged(line, ec != null);
        }
    }
}

