/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.applets.editor;

import com.liferay.applets.editor.EditorUndoManager;
import com.liferay.applets.editor.Lexer;
import com.liferay.applets.editor.LineNumberView;
import com.liferay.applets.editor.Token;
import com.liferay.applets.editor.VmLexer;
import com.liferay.applets.editor.XmlLexer;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import netscape.javascript.JSObject;

public class Editor
extends JApplet {
    private static final int MAX_IMAGE_SIZE = 1024;
    private static final int TAB_SIZE = 28;
    private static final int TAB_COUNT = 50;
    private static final int SEARCH_BWD = -1;
    private static final int SEARCH_HERE = 0;
    private static final int SEARCH_FWD = 1;
    private final JTextPane _textPane = new JTextPane(){
        private static final int MAX_PANEL_WIDTH = Short.MAX_VALUE;

        public void setSize(Dimension d) {
            if (d.width < this.getParent().getSize().width) {
                d.width = this.getParent().getSize().width;
            } else if (d.width > Short.MAX_VALUE) {
                d.width = Short.MAX_VALUE;
            }
            super.setSize(d);
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    };
    private EditorUndoManager _undoMgr = new EditorUndoManager();
    private JButton _undo = this.createButton("undo", "Undo", "Ctrl-Z");
    private JButton _redo = this.createButton("redo", "Redo", "Ctrl-Y");
    private JButton _cut = this.createButton("cut", "Cut", "Ctrl-X");
    private JButton _copy = this.createButton("copy", "Copy", "Ctrl-C");
    private JButton _paste = this.createButton("paste", "Paste", "Ctrl-V");
    private JButton _selAll = this.createButton("select_all", "Select All", "Ctrl-A");
    private JTextField _findField = new JTextField();
    private JLabel _findLabel = new JLabel("Find:");
    private JButton _findNext = new JButton("Next");
    private JButton _findPrev = new JButton("Previous");
    private JCheckBox _caseSensitive = new JCheckBox("Case Sensitive");
    private JLabel _replaceLabel = new JLabel("Replace:");
    private JTextField _replaceField = new JTextField();
    private JButton _replace = new JButton("Replace");
    private JButton _replaceAll = new JButton("Replace All");
    private SyntaxedDocument _doc = new SyntaxedDocument();
    private Highlighter _highlighter = new Highlighter();
    private Lexer _lexer;
    private List _lastTokens;
    private String _lastStr;

    public void init() {
        String lexer = this.getParameter("lexer");
        this._lexer = lexer != null && lexer.toLowerCase().equals("vm") ? new VmLexer() : new XmlLexer();
        this.buildToolbar();
        this.buildTextbody();
        this.buildFindbar();
        ToolTipManager.sharedInstance().setInitialDelay(0);
        this._textPane.requestFocus();
        this._highlighter.start();
        JSObject win = JSObject.getWindow((Applet)this);
        String initData = (String)win.call("getEditorContent", null);
        if (initData != null) {
            this.replaceText(initData);
        }
    }

    public void clear() {
        try {
            this._doc.remove(0, this._doc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public void replaceText(String str) {
        try {
            this.clear();
            this._doc.insertString(0, str, null);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    public String getText() {
        return this.getText(this._doc);
    }

    private void buildToolbar() {
        this._undo.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.undo();
            }
        });
        this._redo.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.redo();
            }
        });
        this._cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.cut();
            }
        });
        this._copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.copy();
            }
        });
        this._paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.paste();
            }
        });
        this._selAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.selectAll();
            }
        });
        this._doc.addUndoableEditListener(this._undoMgr);
        this.updateUndoState();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(this._undo);
        buttons.add(this._redo);
        buttons.add(this._cut);
        buttons.add(this._copy);
        buttons.add(this._paste);
        buttons.add(this._selAll);
        this.getContentPane().add((Component)buttons, "First");
    }

    private void buildTextbody() {
        this._textPane.addKeyListener(new EditorKeyListener());
        this._textPane.setDocument(this._doc);
        this._textPane.setMargin(new Insets(5, 5, 5, 5));
        this._textPane.setCaretPosition(0);
        this._textPane.setFont(this._doc.getFont(Lexer.getDefaultStyle()));
        TabStop[] tabs = new TabStop[50];
        for (int ii = 0; ii < 50; ++ii) {
            tabs[ii] = new TabStop(28 * (ii + 1));
        }
        Style style = this._textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, new TabSet(tabs));
        this._textPane.setLogicalStyle(style);
        JScrollPane scrollpane = new JScrollPane(this._textPane, 20, 30);
        scrollpane.setRowHeaderView(new LineNumberView(this._textPane));
        this.getContentPane().add((Component)scrollpane, "Center");
    }

    private void buildFindbar() {
        this._findNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.find(true, 1);
            }
        });
        this._findPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.find(true, -1);
            }
        });
        this._replace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.replace(false);
            }
        });
        this._replaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Editor.this.replace(true);
            }
        });
        FieldKeyListener fieldKeyListener = new FieldKeyListener();
        this._findField.setToolTipText("Ctrl-F");
        this._findField.addKeyListener(fieldKeyListener);
        this._replaceField.setToolTipText("Ctrl-R");
        this._replaceField.addKeyListener(fieldKeyListener);
        this.setSameWidth(new JButton[]{this._findNext, this._findPrev, this._replace, this._replaceAll});
        GridBagConstraints beg = new GridBagConstraints();
        beg.anchor = 13;
        beg.insets = new Insets(0, 5, 0, 5);
        GridBagConstraints lowmid = new GridBagConstraints();
        lowmid.fill = 2;
        lowmid.weightx = 1.0;
        GridBagConstraints highmid = new GridBagConstraints();
        highmid.anchor = 17;
        GridBagConstraints end = new GridBagConstraints();
        end.gridwidth = 0;
        end.insets = new Insets(0, 0, 0, 5);
        JPanel findBar = new JPanel(new GridBagLayout());
        findBar.add((Component)this._findLabel, beg);
        findBar.add((Component)this._findField, lowmid);
        findBar.add((Component)this._findNext, highmid);
        findBar.add((Component)this._findPrev, highmid);
        findBar.add((Component)this._caseSensitive, end);
        findBar.add((Component)this._replaceLabel, beg);
        findBar.add((Component)this._replaceField, lowmid);
        findBar.add((Component)this._replace, highmid);
        findBar.add((Component)this._replaceAll, highmid);
        this.getContentPane().add((Component)findBar, "Last");
    }

    private void setSameWidth(JButton[] buttons) {
        int ii;
        Dimension widest = null;
        for (ii = 0; ii < buttons.length; ++ii) {
            Dimension dim = buttons[ii].getPreferredSize();
            if (widest != null && dim.width <= widest.width) continue;
            widest = dim;
        }
        for (ii = 0; ii < buttons.length; ++ii) {
            buttons[ii].setPreferredSize(widest);
            buttons[ii].setMinimumSize(widest);
        }
    }

    private JButton createButton(String iconName, String alt, String keystroke) {
        ImageIcon regIcon = this.createAppletIcon(iconName + "-1.gif");
        ImageIcon ovrIcon = this.createAppletIcon(iconName + "-2.gif");
        JButton button = null;
        if (regIcon == null || ovrIcon == null) {
            button = new JButton(alt);
            button.setToolTipText(keystroke);
        } else {
            button = new JButton(regIcon);
            button.setRolloverIcon(ovrIcon);
            button.setToolTipText(alt + " (" + keystroke + ")");
            button.setBorderPainted(false);
        }
        return button;
    }

    private ImageIcon createAppletIcon(String path) {
        ImageIcon icon = null;
        InputStream instrm = this.getClass().getClassLoader().getResourceAsStream("images/" + path);
        BufferedInputStream imgStream = new BufferedInputStream(instrm);
        if (imgStream != null && instrm != null) {
            int count = 0;
            byte[] buf = new byte[1024];
            try {
                count = imgStream.read(buf);
                imgStream.close();
            }
            catch (IOException ex) {
                System.err.println("Problem accessing file: " + path);
                ex.printStackTrace();
            }
            if (count <= 0) {
                System.err.println("Empty file: " + path);
            } else {
                icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(buf));
            }
        } else {
            System.err.println("Couldn't find file: " + path);
        }
        return icon;
    }

    private String getText(Document doc) {
        String str = "";
        try {
            str = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return str;
    }

    private synchronized void updateUndoState() {
        this._undo.setEnabled(this._undoMgr.canUndo());
        this._redo.setEnabled(this._undoMgr.canRedo());
    }

    private final Clipboard getSystemClipboard() {
        Clipboard clipboard = null;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (AccessControlException ex) {
            JOptionPane.showMessageDialog(this, "You did not accept the certificate.  Certificate required for use of clipboard.");
            throw ex;
        }
        return clipboard;
    }

    private void selectAll() {
        this._textPane.setSelectionStart(0);
        this._textPane.setSelectionEnd(this._doc.getLength());
        this._textPane.requestFocus();
    }

    private void cut() {
        if (this._textPane.getSelectedText() != null) {
            StringSelection data = new StringSelection(this._textPane.getSelectedText());
            this.getSystemClipboard().setContents(data, data);
            this._textPane.replaceSelection("");
        }
        this._textPane.requestFocus();
    }

    private void copy() {
        if (this._textPane.getSelectedText() != null) {
            StringSelection data = new StringSelection(this._textPane.getSelectedText());
            this.getSystemClipboard().setContents(data, data);
        }
        this._textPane.requestFocus();
    }

    private void paste() {
        try {
            Clipboard clipboard = this.getSystemClipboard();
            Transferable clipData = clipboard.getContents(clipboard);
            if (clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String str = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                this._textPane.replaceSelection(str);
            }
            this._textPane.requestFocus();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void undo() {
        if (this._undoMgr.canUndo()) {
            try {
                this._undoMgr.undo();
            }
            catch (CannotUndoException ex) {
                ex.printStackTrace();
            }
            this._textPane.requestFocus();
        } else {
            this.getToolkit().beep();
        }
        this.updateUndoState();
    }

    private void redo() {
        if (this._undoMgr.canRedo()) {
            try {
                this._undoMgr.redo();
            }
            catch (CannotRedoException ex) {
                ex.printStackTrace();
            }
            this._textPane.requestFocus();
        } else {
            this.getToolkit().beep();
        }
        this.updateUndoState();
    }

    private boolean find(boolean atomicCall, int direction) {
        boolean found = false;
        try {
            String text = this._doc.getText(0);
            String searchText = this.getText(this._findField.getDocument());
            if (!this._caseSensitive.isSelected()) {
                text = text.toLowerCase();
                searchText = searchText.toLowerCase();
            }
            int index = -1;
            if (direction == -1) {
                int last = this._textPane.getCaretPosition() - searchText.length();
                if (last < 0) {
                    last = text.length() - 1;
                }
                if ((index = text.substring(0, last).lastIndexOf(searchText)) == -1) {
                    index = text.lastIndexOf(searchText);
                }
            } else {
                int start = this._textPane.getCaretPosition();
                if (direction == 0 && this._textPane.getSelectedText() != null) {
                    start = this._textPane.getSelectionStart();
                }
                if ((index = text.indexOf(searchText, start)) == -1) {
                    index = text.indexOf(searchText);
                }
            }
            if (index != -1) {
                this._textPane.setSelectionStart(index);
                this._textPane.setSelectionEnd(index + searchText.length());
                found = true;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        if (atomicCall) {
            if (found) {
                this._textPane.requestFocus();
            } else {
                this._findField.requestFocus();
                this.getToolkit().beep();
            }
        }
        return found;
    }

    private void replace(boolean all) {
        boolean found = false;
        boolean foundSome = false;
        String replaceText = this.getText(this._replaceField.getDocument());
        do {
            if (!(found = this.find(false, 0))) continue;
            foundSome = true;
            this._textPane.replaceSelection(replaceText);
        } while (all && found);
        if (all ? foundSome : found) {
            int caret = this._textPane.getCaretPosition();
            this._textPane.setSelectionStart(caret - replaceText.length());
            this._textPane.setSelectionEnd(caret);
            this._textPane.requestFocus();
        } else {
            this._findField.requestFocus();
            this.getToolkit().beep();
        }
        this.updateUndoState();
    }

    private void update(int dirtBeg, int dirtOffset) {
        try {
            String str = this._doc.getText(0);
            this._lexer.parse(str);
            List tokens = this._lexer.getTokens();
            if (this._lastTokens != null && this._lastTokens.size() != 0) {
                int alpha = this.findPosition(dirtBeg, tokens);
                if (alpha != -1 && tokens.size() != 0) {
                    int omega;
                    int newIdx = alpha;
                    int oldIdx = alpha;
                    if (dirtOffset > 0) {
                        newIdx = this.findPosition(dirtBeg + dirtOffset - 1, tokens);
                    } else {
                        oldIdx = this.findPosition(dirtBeg - dirtOffset - 1, this._lastTokens);
                    }
                    if (newIdx == -1 || oldIdx == -1) {
                        omega = tokens.size() - 1;
                    } else {
                        omega = newIdx;
                        while (newIdx < tokens.size() && oldIdx < this._lastTokens.size()) {
                            Token newTok = (Token)tokens.get(newIdx);
                            Token oldTok = (Token)this._lastTokens.get(oldIdx);
                            if (!oldTok.substrEquals(this._lastStr, newTok, str)) {
                                omega = newIdx;
                            }
                            ++oldIdx;
                            ++newIdx;
                        }
                    }
                    if (alpha > 0) {
                        --alpha;
                    }
                    for (int ii = alpha; ii <= omega; ++ii) {
                        ((Token)tokens.get(ii)).setDirty(true);
                    }
                }
            } else {
                for (int ii = 0; ii < tokens.size(); ++ii) {
                    ((Token)tokens.get(ii)).setDirty(true);
                }
            }
            this._lastTokens = tokens;
            this._lastStr = str;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int findPosition(int position, List tokens) {
        int tokenIdx = -1;
        for (int ii = 0; ii < tokens.size(); ++ii) {
            Token tok = (Token)tokens.get(ii);
            if (tok.getBeg() > position || position > tok.getEnd()) continue;
            tokenIdx = ii;
            break;
        }
        return tokenIdx;
    }

    private void colorDirtyTokens() {
        for (int ii = 0; ii < this._lastTokens.size(); ++ii) {
            Token tok = (Token)this._lastTokens.get(ii);
            if (!tok.isDirty()) continue;
            this._doc.setCharacterAttributes(tok.getBeg(), tok.getOffset(), tok.getStyle());
        }
    }

    private class FieldKeyListener
    implements KeyListener {
        private FieldKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                switch (e.getKeyCode()) {
                    case 70: {
                        Editor.this._findField.requestFocus();
                        e.consume();
                        break;
                    }
                    case 82: {
                        Editor.this._replaceField.requestFocus();
                        e.consume();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class EditorKeyListener
    implements KeyListener {
        private EditorKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.isControlDown()) {
                switch (e.getKeyCode()) {
                    case 65: {
                        Editor.this.selectAll();
                        e.consume();
                        break;
                    }
                    case 67: {
                        Editor.this.copy();
                        e.consume();
                        break;
                    }
                    case 88: {
                        Editor.this.cut();
                        e.consume();
                        break;
                    }
                    case 86: {
                        Editor.this.paste();
                        e.consume();
                        break;
                    }
                    case 90: {
                        Editor.this.undo();
                        e.consume();
                        break;
                    }
                    case 89: {
                        Editor.this.redo();
                        e.consume();
                        break;
                    }
                    case 70: {
                        Editor.this._findField.requestFocus();
                        e.consume();
                        break;
                    }
                    case 82: {
                        Editor.this._replaceField.requestFocus();
                        e.consume();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private class SyntaxedDocument
    extends DefaultStyledDocument {
        private Object _docLock = new Object();

        private SyntaxedDocument() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertString(int offset, String str, AttributeSet att) throws BadLocationException {
            Object object = this._docLock;
            synchronized (object) {
                super.insertString(offset, str, Lexer.getDefaultStyle());
                Editor.this._highlighter.dirty(offset, str.length());
            }
            Editor.this.updateUndoState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int offset, int length) throws BadLocationException {
            Object object = this._docLock;
            synchronized (object) {
                super.remove(offset, length);
                Editor.this._highlighter.dirty(offset, -length);
            }
            Editor.this.updateUndoState();
        }

        public String getText(int offset) throws BadLocationException {
            return this.getText(offset, this.getLength() - offset);
        }

        public void setCharacterAttributes(int offset, int length, AttributeSet s) {
            this.setCharacterAttributes(offset, length, s, true);
        }
    }

    private class Highlighter
    extends Thread {
        private List _mess = new ArrayList();
        private boolean _sleeping = false;

        private Highlighter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dirty(int dirtBeg, int dirtOffset) {
            List list = this._mess;
            synchronized (list) {
                this._mess.add(new Integer[]{new Integer(dirtBeg), new Integer(dirtOffset)});
            }
            if (this._sleeping) {
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                int dirtBeg = -1;
                int dirtOffset = -1;
                List list = this._mess;
                synchronized (list) {
                    if (!this._mess.isEmpty()) {
                        Integer[] pair = (Integer[])this._mess.remove(0);
                        dirtBeg = pair[0];
                        dirtOffset = pair[1];
                    }
                }
                if (dirtBeg != -1) {
                    Editor.this.update(dirtBeg, dirtOffset);
                    Editor.this.colorDirtyTokens();
                    continue;
                }
                try {
                    this._sleeping = true;
                    Highlighter.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    this._sleeping = false;
                    continue;
                }
                break;
            }
        }
    }
}

