// Scroll-Menu by proveo (cm)

var divId = "scrollMenu";
var minX = 0, minY = 20;
var yTimer = 20, xTimer = 20;
var scrYDiv = 8, scrXDiv = 8;
var destXPos = minX;
var outXTimer = 40;
var menuVis = 26;
var blockX = false;
var e;

function initScrolling(scrollDiv)
{
  e = document.getElementById(scrollDiv);
  if (e == null)
  	return;
  e.style.top = minY + "px";
  setTimeout(doYScrolling, yTimer);

  if (scrollX)
  {
	destXPos = (Number(-e.offsetWidth) + Number(menuVis));
	e.style.left = Number(-e.offsetWidth) + "px";
	setTimeout(doXScrolling, xTimer);
  }
  else
	e.style.left = "0px";  
}

function doYScrolling()
{
  if (Number(e.offsetHeight) > document.documentElement.clientHeight)
      e.style.top = minY + "px";
  else
  {
	var scrollTop = 0;
	if (document.body.scrollTop == null || (document.body.scrollTop == 0 && document.documentElement.scrollTop != 0))
		scrollTop = document.documentElement.scrollTop;	// FF, IE
	else
		scrollTop = document.body.scrollTop; // Safari, Chrome
	
    var menuPos = e.style.top.replace("px", "");
    var dist = scrollTop - menuPos + minY;
    var yInc = Number((dist*1000)/scrYDiv);
    if (Math.abs(yInc) > 1500) yInc /= 1000;
    else if (Math.abs(yInc) > 100 ) yInc = (yInc < 0) ? -1 : 1;
         else yInc = 0;
    var calcYPos = Number(menuPos) + yInc;
    e.style.top = (Math.abs(dist) < 2) ? (scrollTop + minY) + "px" : calcYPos + "px";
  }
  setTimeout(doYScrolling, yTimer);
}

function menuXIn()
{
  if (scrollX)
  {
    blockX = true;
    destXPos = minX;
  }
}

function menuXOut()
{
  if (scrollX)
  {
    blockX = false;
    setTimeout(setXOutPos, outXTimer);
  }
}

function setXOutPos()
{
  if (!blockX)
    destXPos = (Number(-e.offsetWidth) + Number(menuVis));
}

function doXScrolling()
{
  var menuPos = e.style.left.replace("px", "");
  var dist = Number(destXPos) - Number(menuPos);
  var xInc = (Number(dist)*1000)/scrXDiv;
  if (Math.abs(xInc) > 1500) xInc /= 1000;
  else if (Math.abs(xInc) > 100 ) xInc = (xInc < 0) ? -1 : 1;
       else xInc = 0;
  var calcXPos = Number(menuPos) + xInc;
  e.style.left = (Math.abs(calcXPos - destXPos) < 2) ? destXPos + "px" : calcXPos + "px";
  setTimeout(doXScrolling, xTimer);
}
        