<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<%@ include file="/html/portlet/workflow/init.jsp" %>

<%
String tabs1 = ParamUtil.getString(request, "tabs1");

ResultRow row = (ResultRow)request.getAttribute(WebKeys.SEARCH_CONTAINER_RESULT_ROW);

String className = row.getClassName();
String classHoverName = row.getClassHoverName();

WorkflowInstance instance = (WorkflowInstance)request.getAttribute(WebKeys.WORKFLOW_INSTANCE);

String instanceId = String.valueOf(instance.getInstanceId());

WorkflowDefinition definition = instance.getDefinition();

WorkflowToken token = (WorkflowToken)request.getAttribute(WebKeys.WORKFLOW_TOKEN);

List tasks = (List)request.getAttribute(WebKeys.WORKFLOW_TASKS);
%>

<c:if test="<%= !instance.isEnded() %>">
	<c:choose>
		<c:when test="<%= tasks.size() > 0 %>">
			<c:if test='<%= tabs1.equals("instances") %>'>
					</td>
				</tr>
			</c:if>

			<%
			for (int i = 0; i < tasks.size(); i++) {
				WorkflowTask task = (WorkflowTask)tasks.get(i);

				String taskId = String.valueOf(task.getTaskId());

				String displayName = null;

				if (token != null) {
					displayName = token.getName();
				}
				else {
					displayName = task.getName();
				}
			%>

				<c:if test='<%= tabs1.equals("instances") %>'>
					<tr class="<%= className %>" onMouseEnter="this.className = '<%= classHoverName %>';" onMouseLeave="this.className = '<%= className %>';">
						<td colspan="5"></td>
						<td>
							<%= LanguageUtil.get(pageContext, displayName) %>
						</td>
						<td align="right" valign="middle">
				</c:if>

				<c:if test="<%= WorkflowTaskPermission.contains(permissionChecker, task, ActionKeys.PERMISSIONS) %>">
					<liferay-security:permissionsURL
						modelResource="<%= WorkflowTask.class.getName() %>"
						modelResourceDescription='<%= definition.getName() + " " + definition.getVersion() + ", " + LanguageUtil.get(pageContext, "instance") + " " + instanceId + ", " + task.getName() %>'
						resourcePrimKey="<%= taskId %>"
						var="permissionsURL"
					/>

					<liferay-ui:icon image="permissions" url="<%= permissionsURL %>" />
				</c:if>

				<c:if test="<%= task.getEndDate() == null %>">
					<c:if test="<%= WorkflowTaskPermission.contains(permissionChecker, task, ActionKeys.MANAGE) %>">
						<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>" var="manageTaskURL">
							<portlet:param name="struts_action" value="/workflow/edit_task" />
							<portlet:param name="redirect" value="<%= currentURL %>" />
							<portlet:param name="instanceId" value="<%= instanceId %>" />
							<portlet:param name="taskId" value="<%= taskId %>" />
						</portlet:renderURL>

						<liferay-ui:icon image="manage_task" message="manage" url="<%= manageTaskURL %>" />
					</c:if>
				</c:if>

			<%
			}
			%>

			<c:if test='<%= tabs1.equals("instances") %>'>
					</td>
				</tr>
			</c:if>
		</c:when>
		<c:otherwise>
			<c:if test='<%= tabs1.equals("instances") %>'>
					</td>
				</tr>
				<tr class="<%= className %>" onMouseEnter="this.className = '<%= classHoverName %>';" onMouseLeave="this.className = '<%= className %>';">
					<td colspan="5"></td>
					<td>
						<%= LanguageUtil.get(pageContext, token.getName()) %>
					</td>
					<td align="right" valign="middle">
			</c:if>

			<c:choose>
				<c:when test='<%= token.getType().equals("join") %>'>
					<%= LanguageUtil.get(pageContext, "waiting-on-sibling-tokens-to-complete") %>
				</c:when>
				<c:otherwise>
					<c:if test="<%= WorkflowInstancePermission.contains(permissionChecker, instance, ActionKeys.SIGNAL) %>">

						<%
						PortletURL signalTokenURL = renderResponse.createActionURL();

						signalTokenURL.setWindowState(WindowState.MAXIMIZED);

						signalTokenURL.setParameter("struts_action", "/workflow/edit_instance");
						signalTokenURL.setParameter(Constants.CMD, Constants.SIGNAL);
						signalTokenURL.setParameter("redirect", currentURL);
						signalTokenURL.setParameter("instanceId", instanceId);
						signalTokenURL.setParameter("tokenId", String.valueOf(token.getTokenId()));
						%>

						<liferay-ui:icon image="signal_instance" message="signal" url="<%= signalTokenURL.toString() %>" />
					</c:if>
				</c:otherwise>
			</c:choose>

			<c:if test='<%= tabs1.equals("instances") %>'>
					</td>
				</tr>
			</c:if>
		</c:otherwise>
	</c:choose>
</c:if>