<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<%@ include file="/html/portlet/wiki/init.jsp" %>

<%
WikiNode node = (WikiNode)request.getAttribute(WebKeys.WIKI_NODE);
WikiPage wikiPage = null;

String nodeId = BeanParamUtil.getString(node, request, "nodeId");

String[] nodeIds = null;

if (node != null) {
	nodeIds = new String[] {nodeId};
}

String keywords = ParamUtil.getString(request, "keywords");
%>

<form action="<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="struts_action" value="/wiki/search" /></portlet:renderURL>" method="post" name="<portlet:namespace />fm" onSubmit="submitForm(this); return false;">
<input name="<portlet:namespace />nodeId" type="hidden" value="<%= nodeId %>">

<%@ include file="/html/portlet/wiki/breadcrumb.jsp" %>

&raquo;

<a href="<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="struts_action" value="/wiki/search" /><portlet:param name="nodeId" value="<%= nodeId %>" /><portlet:param name="keywords" value="<%= keywords %>" /></portlet:renderURL>">
<%= LanguageUtil.get(pageContext, "search") %>
</a>

<br><br>

<%
PortletURL portletURL = renderResponse.createRenderURL();

portletURL.setWindowState(WindowState.MAXIMIZED);

portletURL.setParameter("struts_action", "/wiki/search");
portletURL.setParameter("nodeId", nodeId);
portletURL.setParameter("keywords", keywords);

List headerNames = new ArrayList();

headerNames.add("#");
headerNames.add("node");
headerNames.add("page");
headerNames.add("score");

SearchContainer searchContainer = new SearchContainer(renderRequest, null, null, SearchContainer.DEFAULT_CUR_PARAM, SearchContainer.DEFAULT_DELTA, portletURL, headerNames, LanguageUtil.format(pageContext, "no-pages-were-found-that-matched-the-keywords-x", "<b>" + keywords + "</b>"));

Hits hits = WikiNodeLocalServiceUtil.search(company.getCompanyId(), portletGroupId, nodeIds, keywords);

Hits results = hits.subset(searchContainer.getStart(), searchContainer.getEnd());
int total = hits.getLength();

searchContainer.setTotal(total);

List resultRows = searchContainer.getResultRows();

for (int i = 0; i < results.getLength(); i++) {
	Document doc = results.doc(i);

	ResultRow row = new ResultRow(doc, String.valueOf(i), i);

	// Position

	row.addText(searchContainer.getStart() + i + 1 + StringPool.PERIOD);

	// Node and page

	String curNodeId = doc.get("nodeId");
	String title = doc.get("title");

	WikiNode curNode = WikiNodeLocalServiceUtil.getNode(curNodeId);

	PortletURL rowURL = renderResponse.createRenderURL();

	rowURL.setWindowState(WindowState.MAXIMIZED);

	rowURL.setParameter("struts_action", "/wiki/view_page");
	rowURL.setParameter("nodeId", curNodeId);
	rowURL.setParameter("title", title);

	row.addText(curNode.getName(), rowURL);

	row.addText(title, rowURL);

	// Score

	row.addText(String.valueOf(hits.score(i)), rowURL);

	// Add result row

	resultRows.add(row);
}
%>

<table border="0" cellpadding="0" cellspacing="0" width="100%">
<tr>
	<td>
		<input class="form-text" name="<portlet:namespace />keywords" size="30" type="text" value="<%= keywords %>">

		<input class="portlet-form-button" type="submit" value="<%= LanguageUtil.get(pageContext, "search") %>">
	</td>
	<td align="right">
		<liferay-ui:search-paginator searchContainer="<%= searchContainer %>" />
	</td>
</tr>
</table>

<br>

<liferay-ui:search-iterator searchContainer="<%= searchContainer %>" />

</form>

<script type="text/javascript">
	document.<portlet:namespace />fm.<portlet:namespace />keywords.focus();
</script>