<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<%@ include file="/html/portlet/stocks/init.jsp" %>

<form action="<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="struts_action" value="/stocks/view" /></portlet:renderURL>" method="post" name="<portlet:namespace />fm" onSubmit="submitForm(this); return false;">

<c:choose>
	<c:when test="<%= renderRequest.getWindowState().equals(WindowState.NORMAL) %>">
		<table border="0" cellpadding="0" cellspacing="0">

		<%
		for (int i = 0; i < symbols.length; i++) {
			Stocks stocks = StocksUtil.getStocks(symbols[i]);

			if (stocks != null) {
		%>

				<tr>
					<td>
						<a href="<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="struts_action" value="/stocks/view" /><portlet:param name="symbol" value="<%= stocks.getSymbol() %>" /></portlet:renderURL>" style="font-size: xx-small; font-weight: bold;"><%= stocks.getSymbol() %></a>
					</td>
					<td style="padding-left: 10px;"></td>
					<td align="right">
						<span style="font-size: xx-small;">
						<%= stocks.isLastTradeAvailable() ? decimalFormat.format(stocks.getLastTrade()) : LanguageUtil.get(pageContext, "not-available") %>
						</span>
					</td>
					<td style="padding-left: 10px;"></td>
					<td align="right">
						<c:if test="<%= stocks.getChange() < 0 %>">
							<span class="portlet-msg-error" style="font-size: xx-small;">
							<%= stocks.isChangeAvailable() ? decimalFormat.format(stocks.getChange()) : LanguageUtil.get(pageContext, "not-available") %>
							</span>
						</c:if>

						<c:if test="<%= stocks.getChange() > 0 %>">
							<span class="portlet-msg-success" style="font-size: xx-small;">
							+<%= stocks.isChangeAvailable() ? decimalFormat.format(stocks.getChange()) : LanguageUtil.get(pageContext, "not-available") %>
							</span>
						</c:if>

						<c:if test="<%= stocks.getChange() == 0 %>">
							<span style="font-size: xx-small;">
							<%= stocks.isChangeAvailable() ? decimalFormat.format(stocks.getChange()) : LanguageUtil.get(pageContext, "not-available") %>
							</span>
						</c:if>
					</td>
				</tr>

		<%
			}
		}
		%>

		</table>

		<br>

		<input class="form-text" maxlength="10" name="<portlet:namespace />symbol" size="10" type="text"> <input class="portlet-form-button" type="submit" value='<%= LanguageUtil.get(pageContext, "get-quote") %>'>
	</c:when>
	<c:otherwise>

		<%
		String symbol = ParamUtil.getString(request, "symbol").toUpperCase();

		Stocks stocks = null;

		try {
			stocks = StocksUtil.getStocks(symbol);
		}
		catch (Exception e) {
		}

		int time = ParamUtil.getInteger(request, "time", 8);

		if ((time < 1) || ((time > 13) && (time < 18)) || (time > 20)) {
			time = 8;
		}

		String freq = "1";

		if (time == 1) {
			freq = "9";
		}
		else if (time == 2) {
			freq = "6";
		}
		else if ((time == 3) || (time == 18)) {
			freq = "7";
		}
		else if ((time == 10) || (time == 11) || (time == 12) || (time == 13) || (time == 20)) {
			freq = "2";
		}
		%>

		<input class="form-text" maxlength="10" name="<portlet:namespace />symbol" size="10" type="text" value="<%= symbol %>">

		<select name="<portlet:namespace />time" onChange="submitForm(document.<portlet:namespace />fm);">
			<option <%= (time == 1) ? "selected" : "" %> value="1">1 <%= LanguageUtil.get(pageContext, "day") %></option>
			<option <%= (time == 2) ? "selected" : "" %> value="2">2 <%= LanguageUtil.get(pageContext, "days") %></option>
			<option <%= (time == 3) ? "selected" : "" %> value="3">5 <%= LanguageUtil.get(pageContext, "days") %></option>
			<option <%= (time == 18) ? "selected" : "" %> value="18">10 <%= LanguageUtil.get(pageContext, "days") %></option>
			<option <%= (time == 4) ? "selected" : "" %> value="4">1 <%= LanguageUtil.get(pageContext, "month") %></option>
			<option <%= (time == 5) ? "selected" : "" %> value="5">2 <%= LanguageUtil.get(pageContext, "months") %></option>
			<option <%= (time == 6) ? "selected" : "" %> value="6">3 <%= LanguageUtil.get(pageContext, "months") %></option>
			<option <%= (time == 7) ? "selected" : "" %> value="7">6 <%= LanguageUtil.get(pageContext, "months") %></option>
			<option <%= (time == 19) ? "selected" : "" %> value="19"><%= LanguageUtil.get(pageContext, "year-to-date") %></option>
			<option <%= (time == 8) ? "selected" : "" %> value="8">1 <%= LanguageUtil.get(pageContext, "year") %></option>
			<option <%= (time == 9) ? "selected" : "" %> value="9">2 <%= LanguageUtil.get(pageContext, "years") %></option>
			<option <%= (time == 10) ? "selected" : "" %> value="10">3 <%= LanguageUtil.get(pageContext, "years") %></option>
			<option <%= (time == 11) ? "selected" : "" %> value="11">4 <%= LanguageUtil.get(pageContext, "years") %></option>
			<option <%= (time == 12) ? "selected" : "" %> value="12">5 <%= LanguageUtil.get(pageContext, "years") %></option>
			<option <%= (time == 13) ? "selected" : "" %> value="13">1 <%= LanguageUtil.get(pageContext, "decade") %></option>
			<option <%= (time == 20) ? "selected" : "" %> value="20"><%= LanguageUtil.get(pageContext, "all-data") %></option>
		</select>

		<input class="portlet-form-button" type="submit" value="<%= LanguageUtil.get(pageContext, "get-quote") %>">

		<br><br>

		<c:choose>
			<c:when test="<%= stocks != null %>">
				<table border="1" cellpadding="0" cellspacing="0" width="579">
				<tr>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "last-trade") %><br>
						<b><%= decimalFormat.format(stocks.getLastTrade()) %></b>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "change") %><br>

						<c:if test="<%= stocks.isChangeAvailable() && stocks.isPreviousCloseAvailable() %>">
							<c:if test="<%= stocks.getChange() < 0 %>">
								<span class="portlet-msg-error">
								<b><%= decimalFormat.format(stocks.getChange()) %> / <%= decimalFormat.format(stocks.getChange() / stocks.getPreviousClose()) %>%</b>
								</span>
							</c:if>

							<c:if test="<%= stocks.getChange() > 0 %>">
								<span class="portlet-msg-success">
								<b>+<%= decimalFormat.format(stocks.getChange()) %> / <%= decimalFormat.format(stocks.getChange() / stocks.getPreviousClose()) %>%</b>
								</span>
							</c:if>

							<c:if test="<%= stocks.getChange() == 0 %>">
								<b><%= decimalFormat.format(stocks.getChange()) %> / <%= decimalFormat.format(stocks.getChange() / stocks.getPreviousClose()) %>%</b>
							</c:if>
						</c:if>

						<c:if test="<%= !stocks.isChangeAvailable() || !stocks.isPreviousCloseAvailable() %>">
							<b><%= LanguageUtil.get(pageContext, "not-available") %></b>
						</c:if>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "day-high") %><br>
						<b><%= stocks.isDayHighAvailable() ? decimalFormat.format(stocks.getDayHigh()) : LanguageUtil.get(pageContext, "not-available") %></b>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "day-low") %><br>
						<b><%= stocks.isDayLowAvailable() ? decimalFormat.format(stocks.getDayLow()) : LanguageUtil.get(pageContext, "not-available") %></b>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "open") %><br>
						<b><%= stocks.isOpenAvailable() ? decimalFormat.format(stocks.getOpen()) : LanguageUtil.get(pageContext, "not-available") %></b>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "previous-close") %><br>
						<b><%= stocks.isPreviousCloseAvailable() ? decimalFormat.format(stocks.getPreviousClose()) : LanguageUtil.get(pageContext, "not-available") %></b>
					</td>
					<td align="center">
						<%= LanguageUtil.get(pageContext, "volume") %><br>
						<b><%= stocks.isVolumeAvailable() ? numberFormat.format(stocks.getVolume()) : LanguageUtil.get(pageContext, "not-available") %></b>
					</td>
				</tr>
				</table>

				<br>

				<table border="0" cellpadding="0" cellspacing="0" width="579">
				<tr>
					<td align="center">
						<img src="<%= Http.getProtocol(request) %>://chart.bigcharts.com/bc3/quickchart/chart.asp?symb=<%= symbol %>&freq=<%= freq %>&time=<%= time %>">
					</td>
				</tr>
				</table>
			</c:when>
			<c:otherwise>
				<%= LanguageUtil.format(pageContext, "no-information-was-found-associated-with-the-symbol-x", symbol) %>
			</c:otherwise>
		</c:choose>
	</c:otherwise>
</c:choose>

</form>

<c:if test="<%= renderRequest.getWindowState().equals(WindowState.MAXIMIZED) %>">
	<script type="text/javascript">
		document.<portlet:namespace />fm.<portlet:namespace />symbol.focus();
	</script>
</c:if>