<%
/**
 * Copyright (c) 2000-2007 Liferay, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
%>

<c:if test="<%= news != null %>">
	<tr>
		<td>
			<b><a href="<portlet:renderURL windowState="<%= WindowState.MAXIMIZED.toString() %>"><portlet:param name="struts_action" value="/news/view" /><portlet:param name="url" value="<%= news.getFeedURL() %>" /></portlet:renderURL>">
			<%= news.getName() %>
			</a></b>
		</td>
	</tr>

	<%
	List articles = news.getArticles();

	for (int j = 0; (j < articles.size()) && (j < articlesPerNews); j++) {
		Article article = (Article)articles.get(j);

		String accessStatus = article.getAccessStatus();
	%>

		<c:if test="<%= (j + 1) < articles.size() %>">
			<tr>
				<td>
					<br>
				</td>
			</tr>
		</c:if>

		<tr>
			<td>
				<a href="<%= article.getHeadlineURL() %>" target="_blank"><%= article.getHeadline() %></a><br>

				<span style="font-size: xx-small;">

				<a href="<%= article.getSourceURL() %>" target="_blank"><%= article.getSource() %></a>

				<c:if test='<%= (accessStatus != null) && (accessStatus.equals("reg")) %>'>
					-

					<a href="<%= article.getAccessURL() %>" target="_blank"><%= LanguageUtil.get(pageContext, "registration-required") %></a>
				</c:if>

				<c:if test='<%= (accessStatus != null) && (accessStatus.equals("sub")) %>'>
					-

					<a href="<%= article.getAccessURL() %>" target="_blank"><%= LanguageUtil.get(pageContext, "subscription-required") %></a>
				</c:if>

				-

				<%= dateFormatDateTime.format(article.getDate()) %>

				</span>
			</td>
		</tr>

	<%
	}
	%>

</c:if>

<c:if test="<%= (i + 1) < newsList.size() %>">
	<tr>
		<td>
			<br>
		</td>
	</tr>
</c:if>