
// Some functions for cookie handling

// Set cookie value
//
// param1: name
// param2: value
// param3: expiration in days
// param4: path
// param5: domain
// param6: secure

function setCookie(name, value)
{
	// Prepare arguments
	var args = setCookie.arguments;
	var num_args = setCookie.arguments.length;
	var expires = (num_args > 2) ? args[2] : null;
	var path = (num_args > 3) ? args[3] : null;
	var domain = (num_args > 4) ? args[4] : null;
	var secure = (num_args > 5) ? args[5] : false;
	
	// Calculate expiration date
	var today = new Date();
	if (expires)
	  expires = expires * 1000 * 60 * 60 * 24;
	var expirationDate = new Date(today.getTime() + (expires));
	
	// Set cookie	
	document.cookie = name + "=" + encodeURIComponent(value) +
					  ((expires == null) ? "" : (";expires=" + expirationDate.toGMTString())) +
					  ((path == null) ? "" : (";path=" + path)) +
					  ((domain == null) ? "" : (";domain=" + domain)) +
					  ((secure == true) ? ";secure" : "");
}

// Get cookie value
//
// param1: name of cookie to retrieve
// returns: value of cookie, null on error
function getCookie(name)
{
	var test = document.cookie;
	var start = document.cookie.indexOf(name + "=");
	if ((!start) && (name != document.cookie.substring(0, name.length)))
		return null;
	if ( start == -1 )
		return null;
	var len = start + name.length + 1;
	var end = document.cookie.indexOf( ";", len );
	if ( end == -1 ) end = document.cookie.length;
		return unescape( document.cookie.substring( len, end ) );
}

// Delete cookie
//
// param1: cookie name
function deleteCookie(name)
{
	if (getCookie(name))
		document.cookie = name + "=" +
						  ((path) ? ";path=" + path : "") +
						  ((domain) ? ";domain=" + domain : "" ) +
						  ";expires=Thu, 01-Jan-1970 00:00:01 GMT";
}

// Check for browser cookie support
//
// returns: true, when successful
function checkCookieSupport()
{
	setCookie("test", "none", 20, location.pathname + "/testpath", location.hostname);
	if (getCookie("test"))
		return true;
	else
		return false;
}
