package de.proveo.rts.web.portlet.managedBeans.statusCharts;

import javax.faces.model.SelectItem;

import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.joda.time.Interval;

import de.proveo.rts.web.controller.SessionController;
import de.proveo.rts.web.logicAccess.payloadData.SummarizedDataAccess;
import de.proveo.rts.web.managedBeans.common.data.RtsDataBean;
import de.proveo.rts.web.managedBeans.common.dataSelection.ReportSelectionDTOFactory;
import de.proveo.rts.web.portlet.managedBeans.base.ChartPortletBase;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;
import de.proveo.rts.web.util.charting.Charting;
import de.proveo.wwt.logic.web.summarizedData.dto.StatusDurationsDTOList;

public class StatusPieChartBean extends ChartPortletBase
{

	Integer statusModelId;

	private boolean showLabels;

	private String chartType;
	
	public SelectItem[] getUnitSelectItems()
	{
		// TODO: for SessionScope Bean
		return new RtsDataBean().getBasicUnits();
	}



	public StatusPieChartBean()
	{
		super();

		if (isInitialized())
		{
			statusModelId = Integer.valueOf(RtsPortletUtil.getPreference("statusModelId", "0"));

			showLabels = Boolean.valueOf(RtsPortletUtil.getPreference("showLabels", "false"));

			chartType = RtsPortletUtil.getPreference("chartType", "pie");
			
			if(!RtsPortletUtil.isEditMode())
			{
				update();
			}
		}
		else
		{
			height = 250;
			chartType = "pie";
		}
	}

	public void update()
	{

		Interval interval = getSelectedInterval();
		boolean useGroupHistory = false;

		try
		{
			list = SummarizedDataAccess.getSummarizedDurations(
					ReportSelectionDTOFactory.buildUnitReportSelectionDTO(selectedUnitId, interval.getStartMillis(), interval.getEndMillis(), useGroupHistory),
					statusModelId);

			if (isDataAvailable())
			{
				unitSelectionString = list.getName();

				if (chartType.equals("pie"))
				{
					chart = Charting.createPieChart(((StatusDurationsDTOList)list).get(0), showLegend);
					PiePlot plot = (PiePlot)chart.getPlot();
					if (!showLabels)
						plot.setLabelGenerator(null);
					//if the window is maximized, the tooltips should be activated for this chart
					if(RtsPortletUtil.isWindowMaximized() == false)
					{
						plot.setToolTipGenerator(null);
					}
				}
				else
				{
					chart = Charting.createBarChart(((StatusDurationsDTOList)list).get(0), showLegend);
					CategoryPlot plot = (CategoryPlot)chart.getPlot();
					if (!showLabels)
						plot.getRenderer().setBaseItemLabelGenerator(null);
					
						
				}

				chart.setTitle("");

				chartUrl = RtsPortletUtil.createChartUrl(chart, chartWidth, height, false);
			}
		}
		catch (Exception e)
		{
			errorOccured(e);
		}

	}

	public void save()
	{
		super.save();
		RtsPortletUtil.setPreference("statusModelId", String.valueOf(statusModelId));

		RtsPortletUtil.setPreference("showLabels", String.valueOf(showLabels));
		RtsPortletUtil.setPreference("chartType", String.valueOf(chartType));
	}

	public Integer getStatusModelId()
	{
		return statusModelId;
	}

	public void setStatusModelId(Integer statusModelId)
	{
		this.statusModelId = statusModelId;
	}

	public boolean isShowLabels()
	{
		return showLabels;
	}

	public void setShowLabels(boolean showLabels)
	{
		this.showLabels = showLabels;
	}

	public String getChartType()
	{
		return chartType;
	}

	public void setChartType(String chartType)
	{
		this.chartType = chartType;
	}
	
	public SelectItem[] getStatusModels()
	{
		return RtsPortletUtil.getStatusModels();
	}
}
