package de.proveo.rts.web.portlet.managedBeans.common.dataTable.myfaces;

import java.util.ArrayList;
import java.util.HashMap;

import javax.faces.model.ListDataModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlDataTable;

import de.proveo.rts.web.i18n.LanguageUtil;
import de.proveo.rts.web.logicAccess.masterData.UnitDataAccess;
import de.proveo.rts.web.managedBeans.common.ComponentBaseBean;
import de.proveo.rts.web.util.RtsUtil;
import de.proveo.rts.web.util.time.TimeConvert;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.dto.interfaces.IUnitContainer;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;

/**
 * @author sfiss
 */   
public class MyFacesDataTableBean extends ComponentBaseBean
{

	// Members =================================================================
	//DataTable
	private static final long serialVersionUID = -5519065444574620856L;
	private static final Log log = LogFactory.getLog(MyFacesDataTableBean.class);
	protected transient HtmlDataTable dataTable, exportDataTable;
	private int rowCount;
//	protected transient HtmlDatascroller dataScroller;
	
	//UnitOperationOverview
	private HashMap<Integer, Integer> stateMap = new HashMap<Integer, Integer>();
	private HashMap<Integer, Long> stateBeginTimeMap = new HashMap<Integer, Long>();
	private CurrentAllDTO currentDTO = null;
	private ArrayList<Integer> statusModelList = new ArrayList<Integer>();
	private boolean statusModelListChanged = true;
	private transient ListDataModel columnDataModel = null;
	
	//UnitDataTable
	protected transient ListDataModel dataModel;
	
	// Methods ============================================================
	//DataTable
	public MyFacesDataTableBean()
	{
	//	dataScroller = new HtmlDatascroller();
	}
	protected void createDataTable()
	{
		dataTable = new CustomDataTable();
		dataTable.setRowOnMouseOver("hl(this)");
		dataTable.setRowOnMouseOut("rhl(this)");
	}
	public boolean isInsufficientPermission()
	{
		boolean insufficient = false;
		if (dataTable != null && dataTable.getValue() != null)
		{
			ListDataModel model = (ListDataModel)dataTable.getValue();
			insufficient = ((UnitContainerListBase)model.getWrappedData()).isInsufficientPermissions();
		}
		return insufficient;
	}
	public String getDataInfo()
	{
		String s = "";
		DTOListBase list = getDTOValue();
		if (list != null && list instanceof UnitContainerListBase)
		{
			int i = ((UnitContainerListBase)list).getRemovedDataCount();
			if (i != 0)
				s = String.format(LanguageUtil.getBundleString("dataTable.unauthorizedUnits"), i);
		}
		return s;
	}
	public String getNoDataMessage()
	{
		DTOListBase list = getDTOValue();
		if (list != null && list instanceof UnitContainerListBase && ((UnitContainerListBase)list).isAllDataRemoved())
		{
			return LanguageUtil.getBundleString("common.noDataPermissions");
		}
		return LanguageUtil.getBundleString("common.noDataAvailable");
	}
	private DTOListBase getDTOValue()
	{
		DTOListBase list = null;
		
		if (dataTable != null)
		{
			Object o = dataTable.getValue();
			if (o instanceof ListDataModel)
			{
				o = ((ListDataModel)o).getWrappedData();
				if (o instanceof DTOListBase)
				{
					list = (DTOListBase)o;
				}
			}
		}
		return list;
	}
	public void update()
	{
		//Empty
	}
	
	// Methods =================================================================
	//UnitDataTable
	public String getUnitIconUrl()
	{
		String url = "";
		
		if (dataTable != null && dataTable.isRowAvailable())
		{
			UnitDTO dto = ((IUnitContainer)dataTable.getRowData()).getUnit();
			
			if (dto != null)
			{
				String imageName = dto.getImage();
				url = RtsUtil.getUnitImageUrl(imageName, dto.getUnitModel().getBasic());
			}
		}

		return url;
	}

	public String getUnitType()
	{
		String type = "";
		
		if (dataTable != null && dataTable.isRowAvailable())
		{
			UnitDTO dto = ((IUnitContainer)dataTable.getRowData()).getUnit();
			if (dto != null)
			{
				String unitTypeName = dto.getUnitTypeName();
				if (unitTypeName != null)
					type = unitTypeName;
			}
		}
		
		return type;
	}

	public ListDataModel getDataModel()
	{
		return (dataModel == null) ? new ListDataModel(UnitDataAccess.getUnitModels(true, false)) : dataModel;
	}

	public void setDataModel(ListDataModel model)
	{
		this.dataModel = model;
	}

	public String getTooltipDeleted()
	{
		String tooltip = "";
		
		if (dataTable != null && dataTable.isRowAvailable())
		{
			UnitDTO dto = ((IUnitContainer)dataTable.getRowData()).getUnit();
			if (dto != null)
			{
				StringBuilder toolTip = new StringBuilder(LanguageUtil.getBundleString("unit.deleted"));
				toolTip.append(TimeConvert.convertToShortDateTime(dto.getUnitModel().getDeletedTime()));
				tooltip = toolTip.toString();
			}
		}

		return tooltip;
	}
	
	public boolean isDeleted()
	{
		boolean deleted = false;
		
		if (dataTable != null && dataTable.isRowAvailable())
		{
			UnitDTO dto = ((IUnitContainer)dataTable.getRowData()).getUnit();
			if (dto != null)
				deleted = dto.getUnitModel().getDeleted();
		}
		
		return deleted;
	}
	
	// Methods =================================================================
	//UnitOperationOverview
	public HashMap<Integer, Integer> getStateMap()
	{
		CurrentAllDTO newDTO = (CurrentAllDTO)dataTable.getRowData();
		if (newDTO == null)
			return new HashMap<Integer, Integer>();

		if (currentDTO != newDTO)
		{
			currentDTO = newDTO;
			stateMap.clear();
			for (int i = 0; i != statusModelList.size(); i++)
			{
				Integer currentStatus = statusModelList.get(i);
				StateCache cscv = currentDTO.getStates().get(currentStatus);
				stateMap.put(currentStatus, (cscv == null) ? -1 : cscv.getStateId());
			}
		}

		return stateMap;
	}

	public void setStateMap(HashMap<Long, Long> stateMap)
	{
		// Empty
	}

	public HashMap<Integer, Long> getStateBeginTimeMap()
	{
		CurrentAllDTO newDTO = (CurrentAllDTO)dataTable.getRowData();
		if (newDTO == null)
			return new HashMap<Integer, Long>();
		
		if (currentDTO != newDTO)
		{
			currentDTO = newDTO;
			stateBeginTimeMap.clear();
			for (int i = 0; i != statusModelList.size(); i++)
			{
				Integer currentStatus = statusModelList.get(i);
				StateCache csc = currentDTO.getStates().get(currentStatus);
				stateBeginTimeMap.put(currentStatus, (csc == null) ? null : csc.getBeginTime());
			}
		}

		return stateBeginTimeMap;
	}

	public void setStateBeginTimeMap(HashMap<Long, Long> stateBeginTimeMap)
	{
		// Empty
	}
	
	public ArrayList<Integer> getStatusModelList()
	{
		return statusModelList;
	}

	public void setStatusModelList(ArrayList<Integer> statusModelList)
	{
		this.statusModelList = statusModelList;
		statusModelListChanged = true;
	}
	
	public ListDataModel getColumnDataModel()
	{
		if (statusModelListChanged)
		{
			statusModelListChanged = false;
			columnDataModel = new ListDataModel(statusModelList);
		}
		return columnDataModel;
	}

	public void setColumnDataModel(ListDataModel columnDataModel)
	{
		this.columnDataModel = columnDataModel;
	}
	
	// Getters and setters =====================================================
//	public HtmlDatascroller getDataScroller()
//	{
//		return dataScroller;
//	}
//
//	public void setDataScroller(HtmlDatascroller dataScroller)
//	{
//		this.dataScroller = dataScroller;
//	}

	public int getRowCount()
	{
		return rowCount;
	}

	public void setRowCount(int rowCount)
	{
		this.rowCount = rowCount;
	}

	public HtmlDataTable getDataTable()
	{
		if (dataTable == null)
			createDataTable();
		else
		{
			// This is important if columns change after a request
			dataTable.getChildren().clear();
		}
		return dataTable;
	}

	public void setDataTable(HtmlDataTable dataTable)
	{
		this.dataTable = dataTable;
	}
	
	public String getNotificationSymbolStyle() {
		NotificationDTO dto = (NotificationDTO) dataTable.getRowData();
		return  RtsUtil.getNotificationSymbol(dto.getMessageId());
	}
}
