package de.proveo.rts.web.portlet.managedBeans.base;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;

import de.proveo.rts.web.config.RtsConfig;
import de.proveo.rts.web.phaseListener.ILifeCycleAware;
import de.proveo.rts.web.portlet.util.ChartPortletUtilities;
import de.proveo.rts.web.portlet.util.RtsPortletUtil;
import de.proveo.rts.web.util.charting.ImagemapChart;
import de.proveo.rts.web.util.charting.plot.NotificationPlot;
import de.proveo.rts.web.util.charting.plot.StackedStatusPeaksIntervalXYPlot;
import de.proveo.rts.web.util.charting.plot.StatusStackedBarPlot;
import de.proveo.rts.web.util.charting.plot.StatusSummarizedBarPlot;

public class ChartPortletBase extends ProveoPortletBase implements ILifeCycleAware
{
	private static final Log log = LogFactory.getLog(ChartPortletBase.class);

	protected int chartWidth;

	protected int height;
	
	protected int maxWidth = RtsConfig.configuration.presentation.charts.global.maximizeWidth;;

	protected boolean showLegend = true;

	protected JFreeChart chart;

	protected String chartUrl;
	
	public ArrayList<ImagemapChart> peakCharts;
	
	public ArrayList<JFreeChart> peakChartList;

	public ChartPortletBase()
	{
		super();
		if (isInitialized())
		{
			chartWidth = Integer.valueOf(RtsPortletUtil.getPreference("chartWidth", "0"));
			showLegend = Boolean.valueOf(RtsPortletUtil.getPreference("showLegend", "true"));
			height = Integer.valueOf(RtsPortletUtil.getPreference("height", "10"));
		}
	}

	public String getChart()
	{
		return chartUrl;
	}

	public String getChartUrl()
	{
		return chartUrl;
	}

	public boolean isShowLegend()
	{
		return showLegend;
	}

	public void setShowLegend(boolean showLegend)
	{
		this.showLegend = showLegend;
	}

	public int getChartWidth()
	{
		return chartWidth;
	}

	public void setChartWidth(int chartWidth)
	{
		this.chartWidth = chartWidth;
	}

	public int getHeight()
	{
		return height;
	}

	public void setHeight(int height)
	{
		this.height = height;
	}
	
	public ArrayList<ImagemapChart> getPeakCharts()
	{
		return peakCharts;
	}

	public ArrayList<JFreeChart> getPeakChartList()
	{
		return peakChartList;
	}

	@Override
	public void update()
	{
	// TODO Auto-generated method stub

	}

	@Override
	public void save()
	{
		super.save();
		RtsPortletUtil.setPreference("showLegend", String.valueOf(showLegend));
		RtsPortletUtil.setPreference("chartWidth", String.valueOf(chartWidth));
		RtsPortletUtil.setPreference("height", String.valueOf(height));
	}

	public void onPageLoad()
	{
		if (isInitialized() && isDataAvailable())
		{
			if(RtsPortletUtil.getWindowState() == WindowState.MAXIMIZED && 
					RtsPortletUtil.getPortletMode() == PortletMode.EDIT)
				minimize();
			else
				if (RtsPortletUtil.getWindowState() == WindowState.NORMAL)
					minimize();
				else
					if (RtsPortletUtil.getWindowState() == WindowState.MAXIMIZED)
						maximize();
		}
	}

	private void maximize()
	{
		Plot plot = chart.getPlot();
		if (plot instanceof StatusStackedBarPlot)
		{
			System.out.println("MaxWidth: " + maxWidth);
			chartUrl = RtsPortletUtil.createChartUrl(chart, maxWidth, ((StatusStackedBarPlot)plot).calculateChartHeight(18), true);
		}
		else
			if (plot instanceof NotificationPlot)
			{
				chartUrl = RtsPortletUtil.createChartUrl(chart, maxWidth, ((NotificationPlot)plot).calculateChartHeight(30), true);
			}
			else if (plot instanceof StackedStatusPeaksIntervalXYPlot)
			{
				ArrayList<ImagemapChart> tempChartList = new ArrayList<ImagemapChart>();
				
				for(int i = 0; i != peakChartList.size(); i++)
				{
					JFreeChart tempChart = peakChartList.get(i);
					ImagemapChart imagemapChart = ChartPortletUtilities.createChartUrlWithImageMap(
												  tempChart, maxWidth,(int)(maxWidth * 0.6));
					chartUrl = RtsPortletUtil.createChartUrl(tempChart, maxWidth, (int)(maxWidth * 0.6), true);
					tempChartList.add(imagemapChart);
				}
				peakCharts = tempChartList;					
				
			}
			else if(plot instanceof PiePlot || plot instanceof StatusSummarizedBarPlot)
			{
				chartUrl = RtsPortletUtil.createChartUrl(chart, chartWidth, height, true);
			}
	}

	private void minimize()
	{
		Plot plot = chart.getPlot();
		if (plot instanceof StatusStackedBarPlot)
		{
			chartUrl = RtsPortletUtil.createChartUrl(chart, chartWidth, ((StatusStackedBarPlot)plot).calculateChartHeight(height), true);
		}
		else
			if (plot instanceof NotificationPlot)
			{
				chartUrl = RtsPortletUtil.createChartUrl(chart, chartWidth, ((NotificationPlot)plot).calculateChartHeight(height), true);
			}
			else if(plot instanceof StackedStatusPeaksIntervalXYPlot)
			{
				ArrayList<ImagemapChart> tempChartList = new ArrayList<ImagemapChart>();
				
				for(int i = 0; i != peakChartList.size(); i++)
				{
					JFreeChart tempChart = peakChartList.get(i);
					ImagemapChart imagemapChart = ChartPortletUtilities.createChartUrlWithImageMap(
												  tempChart, chartWidth,(int)(chartWidth * 0.7));
					chartUrl = RtsPortletUtil.createChartUrl(tempChart, chartWidth, (int)(chartWidth * 0.7), true);
					tempChartList.add(imagemapChart);
				}
				peakCharts = tempChartList;
			}
	}

	public static void writeImageMap(String file, ChartRenderingInfo info)
	{
		if (log.isDebugEnabled())
			log.debug("writeImageMap called with file: " + file);

		FacesContext context = FacesContext.getCurrentInstance();
		RenderResponse response = (RenderResponse)context.getExternalContext().getResponse();

		try
		{
			ChartUtilities.writeImageMap(response.getWriter(), file, info, true);
		}
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			log.error("cannot write image map", e);
		}
	}
}
