/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.io.InputStream;
import java.net.MalformedURLException;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.parser.OnlineUserAgentStringParserImpl;
import net.sf.uadetector.parser.UserAgentStringParserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UADetectorServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UADetectorServiceFactory.class);
    private static final String UASDATA = "net/sf/uadetector/resources/uas.xml";

    public static UserAgentStringParser getUserAgentStringParser() {
        return OfflineUserAgentStringParserHolder.INSTANCE;
    }

    public static UserAgentStringParser getOnlineUserAgentStringParser() {
        return OnlineUserAgentStringParserHolder.INSTANCE;
    }

    private UADetectorServiceFactory() {
    }

    private static final class OnlineUserAgentStringParserHolder {
        public static UserAgentStringParser INSTANCE;

        private OnlineUserAgentStringParserHolder() {
        }

        static {
            try {
                InputStream stream = UADetectorServiceFactory.class.getClassLoader().getResourceAsStream(UADetectorServiceFactory.UASDATA);
                INSTANCE = new OnlineUserAgentStringParserImpl(stream);
            }
            catch (MalformedURLException e) {
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private static final class OfflineUserAgentStringParserHolder {
        public static UserAgentStringParser INSTANCE;

        private OfflineUserAgentStringParserHolder() {
        }

        static {
            try {
                InputStream stream = UADetectorServiceFactory.class.getClassLoader().getResourceAsStream(UADetectorServiceFactory.UASDATA);
                INSTANCE = new UserAgentStringParserImpl(stream);
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

