/*
 * Decompiled with CFR 0.152.
 */
package com.proveo.ad.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveDirectory {
    private static final Log log = LogFactory.getLog(ActiveDirectory.class);
    private static String[] userAttributes = new String[]{"distinguishedName", "cn", "name", "uid", "sn", "givenname", "memberOf", "samaccountname", "userPrincipalName"};

    private ActiveDirectory() {
    }

    public static LdapContext getConnection(String username, String password) throws NamingException {
        return ActiveDirectory.getConnection(username, password, null, null);
    }

    public static LdapContext getConnection(String username, String password, String domainName) throws NamingException {
        return ActiveDirectory.getConnection(username, password, domainName, null);
    }

    public static LdapContext getConnection(String username, String password, String domainName, String serverName) throws NamingException {
        if (domainName == null) {
            try {
                String fqdn = InetAddress.getLocalHost().getCanonicalHostName();
                if (fqdn.split("\\.").length > 1) {
                    domainName = fqdn.substring(fqdn.indexOf(".") + 1);
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        String principalName = username + "@" + domainName;
        props.put("java.naming.security.principal", principalName);
        if (password != null) {
            props.put("java.naming.security.credentials", password);
        }
        String ldapURL = "ldap://" + (serverName == null ? domainName : serverName) + '/';
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", ldapURL);
        try {
            return new InitialLdapContext(props, null);
        }
        catch (CommunicationException e) {
            throw new NamingException("Failed to connect to " + domainName + (serverName == null ? "" : " through " + serverName));
        }
        catch (NamingException e) {
            throw new NamingException("Failed to authenticate " + username + "@" + domainName + (serverName == null ? "" : " through " + serverName));
        }
    }

    public static User getUser(String username, LdapContext context) {
        try {
            String domainName = null;
            if (username.contains("@")) {
                username = username.substring(0, username.indexOf("@"));
                domainName = username.substring(username.indexOf("@") + 1);
            } else if (username.contains("\\")) {
                username = username.substring(0, username.indexOf("\\"));
                domainName = username.substring(username.indexOf("\\") + 1);
            } else {
                String authenticatedUser = (String)context.getEnvironment().get("java.naming.security.principal");
                if (authenticatedUser.contains("@")) {
                    domainName = authenticatedUser.substring(authenticatedUser.indexOf("@") + 1);
                }
            }
            if (domainName != null) {
                Attributes attr;
                Attribute user;
                String principalName = username + "@" + domainName;
                SearchControls controls = new SearchControls();
                controls.setSearchScope(2);
                controls.setReturningAttributes(userAttributes);
                NamingEnumeration<SearchResult> answer = context.search(ActiveDirectory.toDC(domainName), "(& (userPrincipalName=" + principalName + ")(objectClass=user))", controls);
                if (answer.hasMore() && (user = (attr = answer.next().getAttributes()).get("userPrincipalName")) != null) {
                    return new User(attr);
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    public static User[] getUsers(LdapContext context) throws NamingException {
        ArrayList<User> users = new ArrayList<User>();
        String authenticatedUser = (String)context.getEnvironment().get("java.naming.security.principal");
        if (authenticatedUser.contains("@")) {
            String domainName = authenticatedUser.substring(authenticatedUser.indexOf("@") + 1);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setReturningAttributes(userAttributes);
            NamingEnumeration<SearchResult> answer = context.search(ActiveDirectory.toDC(domainName), "(objectClass=user)", controls);
            try {
                while (answer.hasMore()) {
                    Attributes attr = answer.next().getAttributes();
                    Attribute user = attr.get("userPrincipalName");
                    if (user == null) continue;
                    users.add(new User(attr));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return users.toArray(new User[users.size()]);
    }

    private static String toDC(String domainName) {
        StringBuilder buf = new StringBuilder();
        for (String token : domainName.split("\\.")) {
            if (token.length() == 0) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("DC=").append(token);
        }
        return buf.toString();
    }

    public static class User {
        private String distinguishedName;
        private String userPrincipal;
        private String commonName;
        private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        private static TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};

        public User(Attributes attr) throws NamingException {
            this.userPrincipal = (String)attr.get("userPrincipalName").get();
            this.commonName = (String)attr.get("cn").get();
            this.distinguishedName = (String)attr.get("distinguishedName").get();
        }

        public String getUserPrincipal() {
            return this.userPrincipal;
        }

        public String getCommonName() {
            return this.commonName;
        }

        public String getDistinguishedName() {
            return this.distinguishedName;
        }

        public String toString() {
            return this.getDistinguishedName();
        }

        public void changePassword(String oldPass, String newPass, boolean trustAllCerts, LdapContext context) throws IOException, NamingException {
            String dn = this.getDistinguishedName();
            StartTlsResponse tls = null;
            try {
                tls = (StartTlsResponse)context.extendedOperation(new StartTlsRequest());
            }
            catch (Exception e) {
                throw new IOException("Failed to establish SSL connection to the Domain Controller. Is LDAPS enabled?");
            }
            if (trustAllCerts) {
                tls.setHostnameVerifier(DO_NOT_VERIFY);
                SSLSocketFactory sf = null;
                try {
                    SSLContext sc = SSLContext.getInstance("TLS");
                    sc.init(null, TRUST_ALL_CERTS, null);
                    sf = sc.getSocketFactory();
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (KeyManagementException e) {
                    // empty catch block
                }
                tls.negotiate(sf);
            } else {
                tls.negotiate();
            }
            try {
                ModificationItem[] modificationItems = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("unicodePwd", this.getPassword(oldPass))), new ModificationItem(1, new BasicAttribute("unicodePwd", this.getPassword(newPass)))};
                context.modifyAttributes(dn, modificationItems);
            }
            catch (InvalidAttributeValueException e) {
                String error = e.getMessage().trim();
                if (error.startsWith("[") && error.endsWith("]")) {
                    error = error.substring(1, error.length() - 1);
                }
                System.err.println(error);
                tls.close();
                throw new NamingException("New password does not meet Active Directory requirements. Please ensure that the new password meets password complexity, length, minimum password age, and password history requirements.");
            }
            catch (NamingException e) {
                tls.close();
                throw e;
            }
            tls.close();
        }

        private byte[] getPassword(String newPass) {
            String quotedPassword = "\"" + newPass + "\"";
            char[] unicodePwd = quotedPassword.toCharArray();
            byte[] pwdArray = new byte[unicodePwd.length * 2];
            for (int i = 0; i < unicodePwd.length; ++i) {
                pwdArray[i * 2 + 1] = (byte)(unicodePwd[i] >>> 8);
                pwdArray[i * 2 + 0] = (byte)(unicodePwd[i] & 0xFF);
            }
            return pwdArray;
        }
    }
}

