/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.AbstractVersionManager;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionItemImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalVersionHistoryImpl
extends InternalVersionItemImpl
implements InternalVersionHistory {
    private static Logger log = LoggerFactory.getLogger((Class)InternalVersionHistory.class);
    private HashMap labelCache = new HashMap();
    private InternalVersion rootVersion;
    private HashMap versionCache = new HashMap();
    private HashMap tempVersionCache = new HashMap();
    private NodeStateEx labelNode;
    private NodeId historyId;
    private NodeId versionableId;

    public InternalVersionHistoryImpl(AbstractVersionManager vMgr, NodeStateEx node) throws RepositoryException {
        super(vMgr, node);
        this.init();
    }

    private void init() throws RepositoryException {
        this.versionCache.clear();
        this.labelCache.clear();
        this.historyId = this.node.getNodeId();
        this.versionableId = NodeId.valueOf(this.node.getPropertyValue(QName.JCR_VERSIONABLEUUID).toString());
        NodeStateEx[] children = this.node.getChildNodes();
        for (int i = 0; i < children.length; ++i) {
            NodeStateEx child = children[i];
            if (child.getName().equals(QName.JCR_VERSIONLABELS)) {
                this.labelNode = child;
                continue;
            }
            InternalVersionImpl v = this.createVersionInstance(child);
            this.versionCache.put(v.getId(), v);
            if (v.isRootVersion()) {
                this.rootVersion = v;
            }
            this.vMgr.versionCreated(v);
        }
        if (this.rootVersion.getSuccessors().length == 0 && this.versionCache.size() > 1) {
            Iterator iter = this.versionCache.values().iterator();
            while (iter.hasNext()) {
                InternalVersionImpl v = (InternalVersionImpl)iter.next();
                v.legacyResolveSuccessors();
            }
        }
        try {
            PropertyState[] labels = this.labelNode.getProperties();
            for (int i = 0; i < labels.length; ++i) {
                PropertyState pState = labels[i];
                if (pState.getType() != 9) continue;
                QName name = pState.getName();
                UUID ref = (UUID)pState.getValues()[0].internalValue();
                InternalVersionImpl v = (InternalVersionImpl)this.getVersion(new NodeId(ref));
                if (v != null) {
                    this.labelCache.put(name, v);
                    v.internalAddLabel(name);
                    continue;
                }
                log.warn("Error while resolving label reference. Version missing: " + ref);
            }
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    void reload() throws RepositoryException {
        this.tempVersionCache.putAll(this.versionCache);
        this.init();
        Iterator iter = this.tempVersionCache.values().iterator();
        while (iter.hasNext()) {
            InternalVersionImpl v = (InternalVersionImpl)iter.next();
            v.invalidate();
        }
        this.tempVersionCache.clear();
    }

    InternalVersionImpl createVersionInstance(NodeStateEx child) {
        InternalVersionImpl v = (InternalVersionImpl)this.tempVersionCache.remove(child.getNodeId());
        if (v != null) {
            v.clear();
        } else {
            v = new InternalVersionImpl(this, child, child.getName());
        }
        return v;
    }

    public NodeId getId() {
        return this.historyId;
    }

    public InternalVersionItem getParent() {
        return null;
    }

    public InternalVersion getRootVersion() {
        return this.rootVersion;
    }

    public InternalVersion getVersion(QName versionName) throws VersionException {
        Iterator iter = this.versionCache.values().iterator();
        while (iter.hasNext()) {
            InternalVersion v = (InternalVersion)iter.next();
            if (!v.getName().equals(versionName)) continue;
            return v;
        }
        throw new VersionException("Version " + versionName + " does not exist.");
    }

    public boolean hasVersion(QName versionName) {
        Iterator iter = this.versionCache.values().iterator();
        while (iter.hasNext()) {
            InternalVersion v = (InternalVersion)iter.next();
            if (!v.getName().equals(versionName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVersion(NodeId id) {
        return this.versionCache.containsKey(id);
    }

    public InternalVersion getVersion(NodeId id) {
        return (InternalVersion)this.versionCache.get(id);
    }

    public InternalVersion getVersionByLabel(QName label) {
        return (InternalVersion)this.labelCache.get(label);
    }

    public Iterator getVersions() {
        return this.versionCache.values().iterator();
    }

    public int getNumVersions() {
        return this.versionCache.size();
    }

    public UUID getVersionableUUID() {
        return this.versionableId.getUUID();
    }

    public QName[] getVersionLabels() {
        return this.labelCache.keySet().toArray(new QName[this.labelCache.size()]);
    }

    public NodeId getVersionLabelsId() {
        return this.labelNode.getNodeId();
    }

    void removeVersion(QName versionName) throws RepositoryException {
        InternalVersionImpl v = (InternalVersionImpl)this.getVersion(versionName);
        if (v.equals(this.rootVersion)) {
            String msg = "Removal of " + versionName + " not allowed.";
            log.debug(msg);
            throw new VersionException(msg);
        }
        List refs = this.vMgr.getItemReferences(v);
        if (!refs.isEmpty()) {
            throw new ReferentialIntegrityException("Unable to remove version. At least once referenced.");
        }
        QName[] labels = v.internalGetLabels();
        for (int i = 0; i < labels.length; ++i) {
            v.internalRemoveLabel(labels[i]);
            this.labelNode.removeProperty(labels[i]);
        }
        v.internalDetach();
        this.node.removeNode(v.getName());
        this.versionCache.remove(v.getId());
        this.vMgr.versionDestroyed(v);
        this.node.store();
    }

    InternalVersion setVersionLabel(QName versionName, QName label, boolean move) throws VersionException {
        InternalVersion version;
        InternalVersion internalVersion = version = versionName != null ? this.getVersion(versionName) : null;
        if (versionName != null && version == null) {
            throw new VersionException("Version " + versionName + " does not exist in this version history.");
        }
        InternalVersionImpl prev = (InternalVersionImpl)this.labelCache.get(label);
        if (prev == null) {
            if (version == null) {
                return null;
            }
        } else {
            if (prev.equals(version)) {
                return version;
            }
            if (!move) {
                throw new VersionException("Version label " + label + " already defined for version " + prev.getName());
            }
        }
        try {
            if (version == null) {
                this.labelNode.removeProperty(label);
            } else {
                this.labelNode.setPropertyValue(label, InternalValue.create(version.getId().getUUID()));
            }
            this.labelNode.store();
        }
        catch (RepositoryException e) {
            throw new VersionException((Throwable)e);
        }
        if (prev != null) {
            prev.internalRemoveLabel(label);
            this.labelCache.remove(label);
        }
        if (version != null) {
            this.labelCache.put(label, version);
            ((InternalVersionImpl)version).internalAddLabel(label);
        }
        return prev;
    }

    InternalVersionImpl checkin(QName name, NodeImpl src) throws RepositoryException {
        Value[] preds = src.getProperty(QName.JCR_PREDECESSORS).getValues();
        InternalValue[] predecessors = new InternalValue[preds.length];
        for (int i = 0; i < preds.length; ++i) {
            UUID predId = UUID.fromString(preds[i].getString());
            if (!this.versionCache.containsKey(new NodeId(predId))) {
                throw new RepositoryException("invalid predecessor in source node");
            }
            predecessors[i] = InternalValue.create(predId);
        }
        NodeId versionId = new NodeId(UUID.randomUUID());
        NodeStateEx vNode = this.node.addNode(name, QName.NT_VERSION, versionId, true);
        vNode.setPropertyValue(QName.JCR_CREATED, InternalValue.create(Calendar.getInstance()));
        vNode.setPropertyValues(QName.JCR_PREDECESSORS, 9, predecessors);
        vNode.setPropertyValues(QName.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        InternalFrozenNodeImpl.checkin(vNode, QName.JCR_FROZENNODE, src);
        InternalVersionImpl version = new InternalVersionImpl(this, vNode, name);
        version.internalAttach();
        this.node.store();
        this.vMgr.versionCreated(version);
        this.versionCache.put(version.getId(), version);
        return version;
    }

    static InternalVersionHistoryImpl create(AbstractVersionManager vMgr, NodeStateEx parent, NodeId historyId, QName name, NodeState nodeState) throws RepositoryException {
        NodeStateEx pNode = parent.addNode(name, QName.NT_VERSIONHISTORY, historyId, true);
        String versionableUUID = nodeState.getNodeId().getUUID().toString();
        pNode.setPropertyValue(QName.JCR_VERSIONABLEUUID, InternalValue.create(versionableUUID));
        pNode.addNode(QName.JCR_VERSIONLABELS, QName.NT_VERSIONLABELS, null, false);
        NodeId versionId = new NodeId(UUID.randomUUID());
        NodeStateEx vNode = pNode.addNode(QName.JCR_ROOTVERSION, QName.NT_VERSION, versionId, true);
        vNode.setPropertyValue(QName.JCR_CREATED, InternalValue.create(Calendar.getInstance()));
        vNode.setPropertyValues(QName.JCR_PREDECESSORS, 9, InternalValue.EMPTY_ARRAY);
        vNode.setPropertyValues(QName.JCR_SUCCESSORS, 9, InternalValue.EMPTY_ARRAY);
        NodeStateEx node = vNode.addNode(QName.JCR_FROZENNODE, QName.NT_FROZENNODE, null, true);
        node.setPropertyValue(QName.JCR_FROZENUUID, InternalValue.create(versionableUUID));
        node.setPropertyValue(QName.JCR_FROZENPRIMARYTYPE, InternalValue.create(nodeState.getNodeTypeName()));
        Set mixins = nodeState.getMixinTypeNames();
        if (mixins.size() > 0) {
            InternalValue[] ivalues = new InternalValue[mixins.size()];
            Iterator iter = mixins.iterator();
            for (int i = 0; i < mixins.size(); ++i) {
                ivalues[i] = InternalValue.create((QName)iter.next());
            }
            node.setPropertyValues(QName.JCR_FROZENMIXINTYPES, 7, ivalues);
        }
        parent.store();
        return new InternalVersionHistoryImpl(vMgr, pNode);
    }
}

