/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PMContext;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.db.DatabasePersistenceManager;
import org.apache.jackrabbit.core.state.db.SimpleDbPersistenceManager;
import org.apache.jackrabbit.core.state.util.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OraclePersistenceManager
extends SimpleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger((Class)OraclePersistenceManager.class);
    private Class blobClass;
    private Integer DURATION_SESSION_CONSTANT;
    private Integer MODE_READWRITE_CONSTANT;

    public OraclePersistenceManager() {
        this.schema = "oracle";
        this.driver = "oracle.jdbc.OracleDriver";
        this.schemaObjectPrefix = "";
        this.user = "";
        this.password = "";
        this.initialized = false;
    }

    public void init(PMContext context) throws Exception {
        super.init(context);
        if (!this.externalBLOBs) {
            this.blobStore = new OracleBLOBStore();
        }
        this.blobClass = this.con.getClass().getClassLoader().loadClass("oracle.sql.BLOB");
        this.DURATION_SESSION_CONSTANT = new Integer(this.blobClass.getField("DURATION_SESSION").getInt(null));
        this.MODE_READWRITE_CONSTANT = new Integer(this.blobClass.getField("MODE_READWRITE").getInt(null));
    }

    public synchronized void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        PreparedStatement stmt = update ? this.nodeStateUpdate : this.nodeStateInsert;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            stmt.setBlob(1, blob);
            stmt.setString(2, state.getId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node state: " + state.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.resetStatement(stmt);
                if (blob != null) {
                    try {
                        this.freeTemporaryBlob(blob);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.resetStatement(stmt);
        if (blob != null) {
            try {
                this.freeTemporaryBlob(blob);
            }
            catch (Exception e1) {}
        }
    }

    public synchronized void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = state.getStatus() != 4;
        PreparedStatement stmt = update ? this.propertyStateUpdate : this.propertyStateInsert;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, out, this.blobStore);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            stmt.setBlob(1, blob);
            stmt.setString(2, state.getId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                String msg = "failed to write property state: " + state.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.resetStatement(stmt);
                if (blob != null) {
                    try {
                        this.freeTemporaryBlob(blob);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.resetStatement(stmt);
        if (blob != null) {
            try {
                this.freeTemporaryBlob(blob);
            }
            catch (Exception e1) {}
        }
    }

    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists(refs.getId());
        PreparedStatement stmt = update ? this.nodeReferenceUpdate : this.nodeReferenceInsert;
        Blob blob = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            blob = this.createTemporaryBlob(new ByteArrayInputStream(out.toByteArray()));
            stmt.setBlob(1, blob);
            stmt.setString(2, refs.getId().toString());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                String msg = "failed to write node references: " + refs.getId();
                log.error(msg, (Throwable)e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.resetStatement(stmt);
                if (blob != null) {
                    try {
                        this.freeTemporaryBlob(blob);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.resetStatement(stmt);
        if (blob != null) {
            try {
                this.freeTemporaryBlob(blob);
            }
            catch (Exception e1) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blob createTemporaryBlob(InputStream in) throws Exception {
        Method createTemporary = this.blobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
        Object blob = createTemporary.invoke(null, this.con, Boolean.FALSE, this.DURATION_SESSION_CONSTANT);
        Method open = this.blobClass.getMethod("open", Integer.TYPE);
        open.invoke(blob, this.MODE_READWRITE_CONSTANT);
        Method getBinaryOutputStream = this.blobClass.getMethod("getBinaryOutputStream", new Class[0]);
        OutputStream out = (OutputStream)getBinaryOutputStream.invoke(blob, null);
        try {
            int read;
            byte[] buf = new byte[8192];
            while ((read = in.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, read);
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException ioe) {}
            out.close();
        }
        Method close = this.blobClass.getMethod("close", new Class[0]);
        close.invoke(blob, null);
        return (Blob)blob;
    }

    protected void freeTemporaryBlob(Object blob) throws Exception {
        Method freeTemporary = this.blobClass.getMethod("freeTemporary", new Class[0]);
        freeTemporary.invoke(blob, null);
    }

    class OracleBLOBStore
    extends DatabasePersistenceManager.DbBLOBStore {
        OracleBLOBStore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            PreparedStatement stmt = OraclePersistenceManager.this.blobSelectExist;
            Blob blob = null;
            try {
                stmt.setString(1, blobId);
                stmt.execute();
                ResultSet rs = stmt.getResultSet();
                boolean exists = rs.next();
                OraclePersistenceManager.this.resetStatement(stmt);
                OraclePersistenceManager.this.closeResultSet(rs);
                stmt = exists ? OraclePersistenceManager.this.blobUpdate : OraclePersistenceManager.this.blobInsert;
                blob = OraclePersistenceManager.this.createTemporaryBlob(in);
                stmt.setBlob(1, blob);
                stmt.setString(2, blobId);
                stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                OraclePersistenceManager.this.resetStatement(stmt);
                if (blob != null) {
                    try {
                        OraclePersistenceManager.this.freeTemporaryBlob(blob);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            OraclePersistenceManager.this.resetStatement(stmt);
            if (blob != null) {
                try {
                    OraclePersistenceManager.this.freeTemporaryBlob(blob);
                }
                catch (Exception e1) {}
            }
        }
    }
}

