/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Collection;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.WeakIdentityCollection;

public class StateChangeDispatcher {
    private final transient Collection listeners = new WeakIdentityCollection(5);
    private final transient Collection nsListeners = new WeakIdentityCollection(5);
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ItemStateListener listener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            if (!$assertionsDisabled && this.listeners.contains(listener)) {
                throw new AssertionError();
            }
            this.listeners.add(listener);
        }
        if (listener instanceof NodeStateListener) {
            collection = this.nsListeners;
            synchronized (collection) {
                if (!$assertionsDisabled && this.nsListeners.contains(listener)) {
                    throw new AssertionError();
                }
                this.nsListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ItemStateListener listener) {
        Collection collection;
        if (listener instanceof NodeStateListener) {
            collection = this.nsListeners;
            synchronized (collection) {
                this.nsListeners.remove(listener);
            }
        }
        collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateCreated(ItemState created) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateCreated(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateModified(ItemState modified) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateModified(modified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateDestroyed(ItemState destroyed) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDestroyed(destroyed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStateDiscarded(ItemState discarded) {
        ItemStateListener[] la;
        Collection collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].stateDiscarded(discarded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNodeAdded(NodeState state, QName name, int index, NodeId id) {
        if (!this.nsListeners.isEmpty()) {
            NodeStateListener[] la;
            Collection collection = this.nsListeners;
            synchronized (collection) {
                la = this.nsListeners.toArray(new NodeStateListener[this.nsListeners.size()]);
            }
            for (int i = 0; i < la.length; ++i) {
                if (la[i] == null) continue;
                la[i].nodeAdded(state, name, index, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNodesReplaced(NodeState state) {
        if (!this.nsListeners.isEmpty()) {
            NodeStateListener[] la;
            Collection collection = this.nsListeners;
            synchronized (collection) {
                la = this.nsListeners.toArray(new NodeStateListener[this.nsListeners.size()]);
            }
            for (int i = 0; i < la.length; ++i) {
                if (la[i] == null) continue;
                la[i].nodesReplaced(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNodeRemoved(NodeState state, QName name, int index, NodeId id) {
        if (!this.nsListeners.isEmpty()) {
            NodeStateListener[] la;
            Collection collection = this.nsListeners;
            synchronized (collection) {
                la = this.nsListeners.toArray(new NodeStateListener[this.nsListeners.size()]);
            }
            for (int i = 0; i < la.length; ++i) {
                if (la[i] == null) continue;
                la[i].nodeRemoved(state, name, index, id);
            }
        }
    }

    static {
        $assertionsDisabled = !StateChangeDispatcher.class.desiredAssertionStatus();
    }
}

