/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.xpath;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.ExactQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.QueryConstants;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.core.query.xpath.XPathQueryBuilder;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;

class QueryFormat
implements QueryNodeVisitor,
QueryConstants {
    private final NamespaceResolver resolver;
    private String statement;
    private List exceptions = new ArrayList();

    private QueryFormat(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        this.resolver = resolver;
        this.statement = root.accept(this, new StringBuffer()).toString();
        if (this.exceptions.size() > 0) {
            Exception e = (Exception)this.exceptions.get(0);
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public static String toString(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        return new QueryFormat(root, resolver).toString();
    }

    public String toString() {
        return this.statement;
    }

    public Object visit(QueryRootNode node, Object data) {
        QName[] selectProps;
        StringBuffer sb = (StringBuffer)data;
        node.getLocationNode().accept(this, data);
        if (node.getOrderNode() != null) {
            node.getOrderNode().accept(this, data);
        }
        if ((selectProps = node.getSelectProperties()).length > 0) {
            boolean union;
            sb.append('/');
            boolean bl = union = selectProps.length > 1;
            if (union) {
                sb.append('(');
            }
            String pipe = "";
            for (int i = 0; i < selectProps.length; ++i) {
                try {
                    sb.append(pipe);
                    sb.append('@');
                    sb.append(NameFormat.format(ISO9075.encode(selectProps[i]), this.resolver));
                    pipe = "|";
                    continue;
                }
                catch (NoPrefixDeclaredException e) {
                    this.exceptions.add(e);
                }
            }
            if (union) {
                sb.append(')');
            }
        }
        return data;
    }

    public Object visit(OrQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        boolean bracket = false;
        if (node.getParent() instanceof AndQueryNode) {
            bracket = true;
        }
        if (bracket) {
            sb.append("(");
        }
        String or = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(or);
            operands[i].accept(this, sb);
            or = " or ";
        }
        if (bracket) {
            sb.append(")");
        }
        return sb;
    }

    public Object visit(AndQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        String and = "";
        QueryNode[] operands = node.getOperands();
        for (int i = 0; i < operands.length; ++i) {
            sb.append(and);
            operands[i].accept(this, sb);
            and = " and ";
        }
        return sb;
    }

    public Object visit(NotQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        QueryNode[] operands = node.getOperands();
        if (operands.length > 0) {
            try {
                sb.append(NameFormat.format(XPathQueryBuilder.FN_NOT_10, this.resolver));
                sb.append("(");
                operands[0].accept(this, sb);
                sb.append(")");
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        }
        return sb;
    }

    public Object visit(ExactQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        sb.append("@");
        try {
            sb.append(NameFormat.format(ISO9075.encode(node.getPropertyName()), this.resolver));
            sb.append("='").append(NameFormat.format(node.getValue(), this.resolver));
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        sb.append("'");
        return sb;
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append("@");
            sb.append(NameFormat.format(QName.JCR_PRIMARYTYPE, this.resolver));
            sb.append("='").append(NameFormat.format(node.getValue(), this.resolver));
            sb.append("'");
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append(NameFormat.format(XPathQueryBuilder.JCR_CONTAINS, this.resolver));
            sb.append("(");
            if (node.getPropertyName() == null) {
                sb.append(".");
            } else {
                sb.append(NameFormat.format(ISO9075.encode(node.getPropertyName()), this.resolver));
            }
            sb.append(", '");
            sb.append(node.getQuery().replaceAll("'", "''"));
            sb.append("')");
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(PathQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        if (node.isAbsolute()) {
            sb.append("/");
        }
        LocationStepQueryNode[] steps = node.getPathSteps();
        String slash = "";
        for (int i = 0; i < steps.length; ++i) {
            sb.append(slash);
            steps[i].accept(this, sb);
            slash = "/";
        }
        return sb;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        if (node.getIncludeDescendants()) {
            sb.append('/');
        }
        if (node.getNameTest() == null) {
            sb.append("*");
        } else {
            try {
                if (node.getNameTest().getLocalName().length() == 0) {
                    sb.append(NameFormat.format(XPathQueryBuilder.JCR_ROOT, this.resolver));
                } else {
                    sb.append(NameFormat.format(ISO9075.encode(node.getNameTest()), this.resolver));
                }
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        }
        if (node.getIndex() != -2147483647) {
            sb.append('[').append(node.getIndex()).append(']');
        }
        QueryNode[] predicates = node.getPredicates();
        for (int i = 0; i < predicates.length; ++i) {
            sb.append('[');
            predicates[i].accept(this, sb);
            sb.append(']');
        }
        return sb;
    }

    public Object visit(DerefQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            sb.append(NameFormat.format(XPathQueryBuilder.JCR_DEREF, this.resolver));
            sb.append("(@");
            sb.append(NameFormat.format(ISO9075.encode(node.getRefProperty()), this.resolver));
            sb.append(", '");
            if (node.getNameTest() == null) {
                sb.append("*");
            } else {
                sb.append(NameFormat.format(ISO9075.encode(node.getNameTest()), this.resolver));
            }
            sb.append("')");
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(RelationQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        try {
            String propName = "@";
            propName = node.getProperty().equals(XPathQueryBuilder.FN_POSITION_FULL) ? propName + NameFormat.format(node.getProperty(), this.resolver) : propName + NameFormat.format(ISO9075.encode(node.getProperty()), this.resolver);
            if (node.getOperation() == 11) {
                sb.append(propName).append(" eq ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 12) {
                sb.append(propName).append(" = ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 20) {
                sb.append(propName).append(" >= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 19) {
                sb.append(propName).append(" ge ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 18) {
                sb.append(propName).append(" > ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 17) {
                sb.append(propName).append(" gt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 22) {
                sb.append(propName).append(" <= ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 21) {
                sb.append(propName).append(" le ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 23) {
                sb.append(NameFormat.format(XPathQueryBuilder.JCR_LIKE, this.resolver));
                sb.append("(").append(propName).append(", ");
                this.appendValue(node, sb);
                sb.append(")");
            } else if (node.getOperation() == 16) {
                sb.append(propName).append(" < ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 15) {
                sb.append(propName).append(" lt ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 14) {
                sb.append(propName).append(" != ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 13) {
                sb.append(propName).append(" ne ");
                this.appendValue(node, sb);
            } else if (node.getOperation() == 26) {
                sb.append(NameFormat.format(XPathQueryBuilder.FN_NOT, this.resolver));
                sb.append("(").append(propName).append(")");
            } else if (node.getOperation() == 27) {
                sb.append(propName);
            } else {
                this.exceptions.add(new InvalidQueryException("Invalid operation: " + node.getOperation()));
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return sb;
    }

    public Object visit(OrderQueryNode node, Object data) {
        StringBuffer sb = (StringBuffer)data;
        sb.append(" order by");
        OrderQueryNode.OrderSpec[] specs = node.getOrderSpecs();
        String comma = "";
        try {
            for (int i = 0; i < specs.length; ++i) {
                sb.append(comma);
                QName prop = ISO9075.encode(specs[i].getProperty());
                sb.append(" @").append(NameFormat.format(prop, this.resolver));
                if (!specs[i].isAscending()) {
                    sb.append(" descending");
                }
                comma = ",";
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return data;
    }

    private void appendValue(RelationQueryNode node, StringBuffer b) throws NoPrefixDeclaredException {
        if (node.getValueType() == 1) {
            b.append(node.getLongValue());
        } else if (node.getValueType() == 2) {
            b.append(node.getDoubleValue());
        } else if (node.getValueType() == 3) {
            b.append("'").append(node.getStringValue().replaceAll("'", "''")).append("'");
        } else if (node.getValueType() == 4 || node.getValueType() == 5) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.setTime(node.getDateValue());
            b.append(NameFormat.format(XPathQueryBuilder.XS_DATETIME, this.resolver));
            b.append("('").append(ISO8601.format(cal)).append("')");
        } else if (node.getValueType() == 6) {
            if (node.getPositionValue() == Integer.MIN_VALUE) {
                b.append("last()");
            } else {
                b.append(node.getPositionValue());
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Invalid type: " + node.getValueType()));
        }
    }
}

