/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

class DescendantSelfAxisQuery
extends Query {
    private static final Float DEFAULT_SCORE = new Float(1.0f);
    private final Query contextQuery;
    private Scorer contextScorer;
    private final Query subQuery;
    private final boolean includeSelf;
    private Scorer subScorer;

    public DescendantSelfAxisQuery(Query context, Query sub) {
        this(context, sub, true);
    }

    public DescendantSelfAxisQuery(Query context, Query sub, boolean includeSelf) {
        this.contextQuery = context;
        this.subQuery = sub;
        this.includeSelf = includeSelf;
    }

    protected Weight createWeight(Searcher searcher) {
        return new DescendantSelfAxisWeight(searcher);
    }

    public String toString(String field) {
        return "DescendantSelfAxisQuery";
    }

    private class DescendantSelfAxisScorer
    extends Scorer {
        private final HierarchyResolver hResolver;
        private final BitSet contextHits;
        private final BitSet subHits;
        private final Map scores;
        private int nextDoc;
        private boolean subHitsCalculated;

        protected DescendantSelfAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.scores = new HashMap();
            this.nextDoc = -1;
            this.subHitsCalculated = false;
            this.hResolver = hResolver;
            this.contextHits = new BitSet(reader.maxDoc());
            this.subHits = new BitSet(reader.maxDoc());
        }

        public boolean next() throws IOException {
            this.calculateSubHits();
            this.nextDoc = this.subHits.nextSetBit(this.nextDoc + 1);
            while (this.nextDoc > -1) {
                if (DescendantSelfAxisQuery.this.includeSelf && this.contextHits.get(this.nextDoc)) {
                    return true;
                }
                int parentDoc = this.hResolver.getParent(this.nextDoc);
                while (parentDoc != -1 && !this.contextHits.get(parentDoc)) {
                    parentDoc = this.hResolver.getParent(parentDoc);
                }
                if (parentDoc != -1) {
                    this.contextHits.set(parentDoc);
                    return true;
                }
                this.nextDoc = this.subHits.nextSetBit(this.nextDoc + 1);
            }
            return false;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            Float score = (Float)this.scores.get(new Integer(this.nextDoc));
            if (score == null) {
                score = DEFAULT_SCORE;
            }
            return score.floatValue();
        }

        public boolean skipTo(int target) throws IOException {
            this.nextDoc = target - 1;
            return this.next();
        }

        private void calculateSubHits() throws IOException {
            if (!this.subHitsCalculated) {
                DescendantSelfAxisQuery.this.contextScorer.score(new HitCollector(){

                    public void collect(int doc, float score) {
                        DescendantSelfAxisScorer.this.contextHits.set(doc);
                    }
                });
                if (!this.contextHits.isEmpty()) {
                    DescendantSelfAxisQuery.this.subScorer.score(new HitCollector(){

                        public void collect(int doc, float score) {
                            DescendantSelfAxisScorer.this.subHits.set(doc);
                            if (score != DEFAULT_SCORE.floatValue()) {
                                DescendantSelfAxisScorer.this.scores.put(new Integer(doc), new Float(score));
                            }
                        }
                    });
                }
                this.subHitsCalculated = true;
            }
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class DescendantSelfAxisWeight
    implements Weight {
        private final Searcher searcher;

        private DescendantSelfAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DescendantSelfAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            DescendantSelfAxisQuery.this.contextScorer = DescendantSelfAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader);
            DescendantSelfAxisQuery.this.subScorer = DescendantSelfAxisQuery.this.subQuery.weight(this.searcher).scorer(reader);
            HierarchyResolver resolver = (HierarchyResolver)reader;
            return new DescendantSelfAxisScorer(this.searcher.getSimilarity(), reader, resolver);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

