/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyTypeRegistry
implements NodeTypeRegistryListener {
    private static final Logger log = LoggerFactory.getLogger((Class)PropertyTypeRegistry.class);
    private static final TypeMapping[] EMPTY = new TypeMapping[0];
    private final NodeTypeRegistry registry;
    private final Map typeMapping = new HashMap();

    public PropertyTypeRegistry(NodeTypeRegistry reg) {
        this.registry = reg;
        this.fillCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMapping[] getPropertyTypes(QName propName) {
        Map map = this.typeMapping;
        synchronized (map) {
            TypeMapping[] types = (TypeMapping[])this.typeMapping.get(propName);
            if (types != null) {
                return types;
            }
            return EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeRegistered(QName ntName) {
        try {
            NodeTypeDef def = this.registry.getNodeTypeDef(ntName);
            PropDef[] propDefs = def.getPropertyDefs();
            Map map = this.typeMapping;
            synchronized (map) {
                for (int i = 0; i < propDefs.length; ++i) {
                    int type = propDefs[i].getRequiredType();
                    if (propDefs[i].definesResidual() || type == 0) continue;
                    QName name = propDefs[i].getName();
                    TypeMapping[] types = (TypeMapping[])this.typeMapping.get(name);
                    if (types == null) {
                        types = new TypeMapping[1];
                    } else {
                        TypeMapping[] tmp = new TypeMapping[types.length + 1];
                        System.arraycopy(types, 0, tmp, 0, types.length);
                        types = tmp;
                    }
                    types[types.length - 1] = new TypeMapping(ntName, type, propDefs[i].isMultiple());
                    this.typeMapping.put(name, types);
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            log.error("Unable to get newly registered node type definition for name: " + ntName);
        }
    }

    public void nodeTypeReRegistered(QName ntName) {
        this.nodeTypeUnregistered(ntName);
        this.nodeTypeRegistered(ntName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(QName ntName) {
        Map map = this.typeMapping;
        synchronized (map) {
            HashMap<QName, TypeMapping[]> modified = new HashMap<QName, TypeMapping[]>();
            Iterator it = this.typeMapping.keySet().iterator();
            while (it.hasNext()) {
                QName propName = (QName)it.next();
                TypeMapping[] mapping = (TypeMapping[])this.typeMapping.get(propName);
                ArrayList<TypeMapping> remove = null;
                for (int i = 0; i < mapping.length; ++i) {
                    if (!mapping[i].ntName.equals(ntName)) continue;
                    if (remove == null) {
                        remove = new ArrayList<TypeMapping>(mapping.length);
                    }
                    remove.add(mapping[i]);
                }
                if (remove == null) continue;
                it.remove();
                if (mapping.length == remove.size()) continue;
                ArrayList<TypeMapping> remaining = new ArrayList<TypeMapping>(Arrays.asList(mapping));
                remaining.removeAll(remove);
                modified.put(propName, remaining.toArray(new TypeMapping[remaining.size()]));
            }
            this.typeMapping.putAll(modified);
        }
    }

    private void fillCache() {
        QName[] ntNames = this.registry.getRegisteredNodeTypes();
        for (int i = 0; i < ntNames.length; ++i) {
            this.nodeTypeRegistered(ntNames[i]);
        }
    }

    public static class TypeMapping {
        public final int type;
        final QName ntName;
        public final boolean isMultiValued;

        private TypeMapping(QName ntName, int type, boolean isMultiValued) {
            this.type = type;
            this.ntName = ntName;
            this.isMultiValued = isMultiValued;
        }
    }
}

