/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.core.nodetype.ItemDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ItemDefinitionImpl
implements ItemDefinition {
    private static Logger log = LoggerFactory.getLogger((Class)ItemDefinitionImpl.class);
    protected static final String ANY_NAME = "*";
    protected final NodeTypeManagerImpl ntMgr;
    protected final NamespaceResolver nsResolver;
    protected final ItemDef itemDef;

    ItemDefinitionImpl(ItemDef itemDef, NodeTypeManagerImpl ntMgr, NamespaceResolver nsResolver) {
        this.itemDef = itemDef;
        this.ntMgr = ntMgr;
        this.nsResolver = nsResolver;
    }

    public boolean definesResidual() {
        return this.itemDef.definesResidual();
    }

    public QName getQName() {
        return this.itemDef.getName();
    }

    public NodeType getDeclaringNodeType() {
        try {
            return this.ntMgr.getNodeType(this.itemDef.getDeclaringNodeType());
        }
        catch (NoSuchNodeTypeException e) {
            log.error("declaring node type does not exist", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        if (this.itemDef.definesResidual()) {
            return ANY_NAME;
        }
        try {
            return NameFormat.format(this.itemDef.getName(), this.nsResolver);
        }
        catch (NoPrefixDeclaredException npde) {
            log.error("encountered unregistered namespace in property name", (Throwable)npde);
            return this.itemDef.getName().toString();
        }
    }

    public int getOnParentVersion() {
        return this.itemDef.getOnParentVersion();
    }

    public boolean isAutoCreated() {
        return this.itemDef.isAutoCreated();
    }

    public boolean isMandatory() {
        return this.itemDef.isMandatory();
    }

    public boolean isProtected() {
        return this.itemDef.isProtected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemDefinitionImpl)) {
            return false;
        }
        return this.itemDef.equals(((ItemDefinitionImpl)o).itemDef);
    }

    public int hashCode() {
        return this.itemDef.hashCode();
    }
}

