/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.jndi.BindableRepository;

public class BindableRepositoryFactory
implements ObjectFactory {
    private static Map cache = new ReferenceMap(0, 1);

    static BindableRepository createInstance(String configFilePath, String repHomeDir) throws RepositoryException {
        BindableRepository rep = BindableRepository.create(configFilePath, repHomeDir);
        cache.put(rep.getReference(), rep);
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            Map map = cache;
            synchronized (map) {
                if (cache.containsKey(ref)) {
                    return cache.get(ref);
                }
                String configFilePath = (String)ref.get("configFilePath").getContent();
                String repHomeDir = (String)ref.get("repHomeDir").getContent();
                return BindableRepositoryFactory.createInstance(configFilePath, repHomeDir);
            }
        }
        return null;
    }
}

