/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.ConfigurationParser;
import org.apache.jackrabbit.core.config.FileSystemConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RepositoryConfigurationParser
extends ConfigurationParser {
    public static final String REPOSITORY_HOME_VARIABLE = "rep.home";
    public static final String WORKSPACE_HOME_VARIABLE = "wsp.home";
    public static final String WORKSPACE_NAME_VARIABLE = "wsp.name";
    public static final String SECURITY_ELEMENT = "Security";
    public static final String ACCESS_MANAGER_ELEMENT = "AccessManager";
    public static final String LOGIN_MODULE_ELEMENT = "LoginModule";
    public static final String WORKSPACES_ELEMENT = "Workspaces";
    public static final String WORKSPACE_ELEMENT = "Workspace";
    public static final String VERSIONING_ELEMENT = "Versioning";
    public static final String FILE_SYSTEM_ELEMENT = "FileSystem";
    public static final String PERSISTENCE_MANAGER_ELEMENT = "PersistenceManager";
    public static final String SEARCH_INDEX_ELEMENT = "SearchIndex";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String ROOT_PATH_ATTRIBUTE = "rootPath";
    public static final String CONFIG_ROOT_PATH_ATTRIBUTE = "configRootPath";
    public static final String MAX_IDLE_TIME_ATTRIBUTE = "maxIdleTime";
    public static final String DEFAULT_WORKSPACE_ATTRIBUTE = "defaultWorkspace";
    public static final String DEFAULT_QUERY_HANDLER = "org.apache.jackrabbit.core.query.lucene.SearchIndex";

    public RepositoryConfigurationParser(Properties variables) {
        super(variables);
    }

    public RepositoryConfig parseRepositoryConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.getVariables().getProperty(REPOSITORY_HOME_VARIABLE);
        FileSystemConfig fsc = new FileSystemConfig(this.parseBeanConfig(root, FILE_SYSTEM_ELEMENT));
        Element security = this.getElement(root, SECURITY_ELEMENT);
        SecurityConfig securityConfig = this.parseSecurityConfig(security);
        Element workspaces = this.getElement(root, WORKSPACES_ELEMENT);
        String workspaceDirectory = this.replaceVariables(this.getAttribute(workspaces, ROOT_PATH_ATTRIBUTE));
        String workspaceConfigDirectory = this.getAttribute(workspaces, CONFIG_ROOT_PATH_ATTRIBUTE, null);
        String defaultWorkspace = this.replaceVariables(this.getAttribute(workspaces, DEFAULT_WORKSPACE_ATTRIBUTE));
        int maxIdleTime = Integer.parseInt(this.getAttribute(workspaces, MAX_IDLE_TIME_ATTRIBUTE, "0"));
        Element template = this.getElement(root, WORKSPACE_ELEMENT);
        VersioningConfig vc = this.parseVersioningConfig(root);
        SearchConfig sc = this.parseSearchConfig(root);
        return new RepositoryConfig(home, securityConfig, fsc, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, maxIdleTime, template, vc, sc, this);
    }

    public SecurityConfig parseSecurityConfig(Element security) throws ConfigurationException {
        String appName = this.getAttribute(security, APP_NAME_ATTRIBUTE);
        AccessManagerConfig amc = this.parseAccessManagerConfig(security);
        LoginModuleConfig lmc = this.parseLoginModuleConfig(security);
        return new SecurityConfig(appName, amc, lmc);
    }

    public AccessManagerConfig parseAccessManagerConfig(Element security) throws ConfigurationException {
        return new AccessManagerConfig(this.parseBeanConfig(security, ACCESS_MANAGER_ELEMENT));
    }

    public LoginModuleConfig parseLoginModuleConfig(Element security) throws ConfigurationException {
        Element loginModule = this.getElement(security, LOGIN_MODULE_ELEMENT, false);
        if (loginModule != null) {
            return new LoginModuleConfig(this.parseBeanConfig(security, LOGIN_MODULE_ELEMENT));
        }
        return null;
    }

    public WorkspaceConfig parseWorkspaceConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.getVariables().getProperty(WORKSPACE_HOME_VARIABLE);
        String name = this.getAttribute(root, "name", new File(home).getName());
        Properties tmpVariables = (Properties)this.getVariables().clone();
        tmpVariables.put(WORKSPACE_NAME_VARIABLE, name);
        RepositoryConfigurationParser tmpParser = this.createSubParser(tmpVariables);
        FileSystemConfig fsc = new FileSystemConfig(tmpParser.parseBeanConfig(root, FILE_SYSTEM_ELEMENT));
        PersistenceManagerConfig pmc = tmpParser.parsePersistenceManagerConfig(root);
        SearchConfig sc = tmpParser.parseSearchConfig(root);
        return new WorkspaceConfig(home, name, fsc, pmc, sc);
    }

    protected SearchConfig parseSearchConfig(Element parent) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !SEARCH_INDEX_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String className = this.getAttribute(element, "class", DEFAULT_QUERY_HANDLER);
            Properties parameters = this.parseParameters(element);
            FileSystemConfig fsc = null;
            if (this.getElement(element, FILE_SYSTEM_ELEMENT, false) != null) {
                fsc = new FileSystemConfig(this.parseBeanConfig(element, FILE_SYSTEM_ELEMENT));
            }
            return new SearchConfig(className, parameters, fsc);
        }
        return null;
    }

    protected VersioningConfig parseVersioningConfig(Element parent) throws ConfigurationException {
        Element element = this.getElement(parent, VERSIONING_ELEMENT);
        String home = this.replaceVariables(this.getAttribute(element, ROOT_PATH_ATTRIBUTE));
        FileSystemConfig fsc = new FileSystemConfig(this.parseBeanConfig(element, FILE_SYSTEM_ELEMENT));
        PersistenceManagerConfig pmc = this.parsePersistenceManagerConfig(element);
        return new VersioningConfig(home, fsc, pmc);
    }

    protected PersistenceManagerConfig parsePersistenceManagerConfig(Element parent) throws ConfigurationException {
        return new PersistenceManagerConfig(this.parseBeanConfig(parent, PERSISTENCE_MANAGER_ELEMENT));
    }

    protected RepositoryConfigurationParser createSubParser(Properties variables) {
        Properties props = new Properties(this.getVariables());
        props.putAll((Map<?, ?>)variables);
        return new RepositoryConfigurationParser(props);
    }
}

