/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.filters.secure;

import com.liferay.portal.util.PropsUtil;
import com.liferay.util.CollectionFactory;
import com.liferay.util.GetterUtil;
import com.liferay.util.Http;
import com.liferay.util.StringUtil;
import com.liferay.util.Validator;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SecureFilter
implements Filter {
    private static final String _SERVER_IP = "SERVER_IP";
    private static Log _log;
    private Set _hostsAllowed;
    private boolean _httpsRequired;
    static /* synthetic */ Class class$com$liferay$filters$secure$SecureFilter;

    public void init(FilterConfig config) {
        String propertyPrefix = config.getInitParameter("portal_property_prefix");
        String[] hostsAllowedArray = null;
        if (Validator.isNull((String)propertyPrefix)) {
            hostsAllowedArray = StringUtil.split((String)config.getInitParameter("hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)config.getInitParameter("https.required"));
        } else {
            hostsAllowedArray = PropsUtil.getArray((String)(propertyPrefix + "hosts.allowed"));
            this._httpsRequired = GetterUtil.getBoolean((String)PropsUtil.get((String)(propertyPrefix + "https.required")));
        }
        int i = 0;
        while (i < hostsAllowedArray.length) {
            this._hostsAllowed.add(hostsAllowedArray[i]);
            ++i;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String remoteAddr = req.getRemoteAddr();
        if (this.isAccessAllowed(req)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
        } else {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Access denied for " + remoteAddr));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            if (this._httpsRequired) {
                _log.debug((Object)"https is required");
            } else {
                _log.debug((Object)"https is not required");
            }
        }
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        String completeURL = Http.getCompleteURL((HttpServletRequest)httpReq);
        if (this._httpsRequired && !httpReq.isSecure()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Securing " + completeURL));
            }
            StringBuffer redirectURL = new StringBuffer();
            redirectURL.append("https://");
            redirectURL.append(httpReq.getServerName());
            redirectURL.append(httpReq.getServletPath());
            String queryString = httpReq.getQueryString();
            if (Validator.isNotNull((String)queryString)) {
                redirectURL.append("?");
                redirectURL.append(httpReq.getQueryString());
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect to " + redirectURL));
            }
            httpRes.sendRedirect(redirectURL.toString());
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not securing " + completeURL));
            }
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    protected boolean isAccessAllowed(ServletRequest req) {
        String remoteAddr = req.getRemoteAddr();
        String serverIp = req.getServerName();
        if (this._hostsAllowed.size() > 0 && !this._hostsAllowed.contains(remoteAddr)) {
            return serverIp.equals(remoteAddr) && this._hostsAllowed.contains(_SERVER_IP);
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this._hostsAllowed = CollectionFactory.getHashSet();
    }

    public SecureFilter() {
        this.this();
    }

    static {
        Class clazz = class$com$liferay$filters$secure$SecureFilter;
        if (clazz == null) {
            clazz = class$com$liferay$filters$secure$SecureFilter = SecureFilter.class("[Lcom.liferay.filters.secure.SecureFilter;", false);
        }
        _log = LogFactory.getLog((Class)clazz);
    }
}

