/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.jboss.security.android;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.security.Util;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public abstract class AndroidUsernamePasswordLoginModule
extends AbstractServerLoginModule {
    private static final Log log = LogFactory.getLog(AndroidUsernamePasswordLoginModule.class);
    private Principal identity;
    private String hashAlgorithm = null;
    private String hashCharset = null;
    private String hashEncoding = null;
    private char[] credential;
    private boolean ignorePasswordCase;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        log.debug((Object)"Start initialization");
        this.hashAlgorithm = (String)options.get("hashAlgorithm");
        if (this.hashAlgorithm != null) {
            this.hashEncoding = (String)options.get("hashEncoding");
            if (this.hashEncoding == null) {
                this.hashEncoding = "BASE64";
            }
            this.hashCharset = (String)options.get("hashCharset");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Password hashing activated: algorithm = " + this.hashAlgorithm + ", encoding = " + this.hashEncoding + ", charset = " + (this.hashCharset == null ? "{default}" : this.hashCharset) + ", callback = " + options.get("digestCallback")));
            }
        }
        String flag = (String)options.get("ignorePasswordCase");
        this.ignorePasswordCase = Boolean.valueOf(flag);
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    log.debug((Object)"Failed to create principal", (Throwable)e);
                    throw new LoginException("Failed to create principal: " + e.getMessage());
                }
            }
            Object password = this.sharedState.get("javax.security.auth.login.password");
            if (password instanceof char[]) {
                this.credential = (char[])password;
            } else if (password != null) {
                String tmp = password.toString();
                this.credential = tmp.toCharArray();
            }
            return true;
        }
        this.loginOk = false;
        String[] info = this.getUsernameAndPassword();
        String username = info[0];
        String password = info[1];
        if (username == null && password == null) {
            this.identity = this.unauthenticatedIdentity;
            log.debug((Object)("Authenticating as unauthenticatedIdentity=" + this.identity));
        }
        if (this.identity == null) {
            String expectedPassword;
            try {
                this.identity = this.createIdentity(username);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to create principal", (Throwable)e);
                throw new LoginException("Failed to create principal: " + e.getMessage());
            }
            if (this.hashAlgorithm != null) {
                password = this.createPasswordHash(username, password);
            }
            if (!this.validatePassword(password, expectedPassword = this.getUsersPassword())) {
                log.debug((Object)("Bad password for username=" + username));
                throw new FailedLoginException("Password Incorrect/Password Required");
            }
        }
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", username);
            this.sharedState.put("javax.security.auth.login.password", this.credential);
        }
        this.loginOk = true;
        log.debug((Object)("User '" + this.identity + "' authenticated, loginOk=" + this.loginOk));
        return true;
    }

    protected String createPasswordHash(String username, String password) {
        DigestCallback callback = null;
        String callbackClassName = (String)this.options.get("digestCallback");
        if (callbackClassName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> callbackClass = loader.loadClass(callbackClassName);
                callback = (DigestCallback)callbackClass.newInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created DigestCallback: " + callback));
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Failed to load DigestCallback", (Throwable)e);
                }
                SecurityException ex = new SecurityException("Failed to load DigestCallback");
                ex.initCause(e);
                throw ex;
            }
            HashMap<String, String> tmp = new HashMap<String, String>(this.options);
            tmp.put("javax.security.auth.login.name", username);
            tmp.put("javax.security.auth.login.password", password);
            callback.init(tmp);
        }
        String passwordHash = Util.createPasswordHash((String)this.hashAlgorithm, (String)this.hashEncoding, (String)this.hashCharset, (String)username, (String)password, callback);
        return passwordHash;
    }

    protected Object getCredentials() {
        return this.credential;
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Principal getUnauthenticatedIdentity() {
        return this.unauthenticatedIdentity;
    }

    protected String getUsername() {
        String username = null;
        if (this.getIdentity() != null) {
            username = this.getIdentity().getName();
        }
        return username;
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] info = new String[]{null, null};
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to collect authentication information");
        }
        NameCallback nc = new NameCallback("User name: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        Callback[] callbacks = new Callback[]{nc, pc};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = nc.getName();
            char[] tmpPassword = pc.getPassword();
            if (tmpPassword != null) {
                this.credential = new char[tmpPassword.length];
                System.arraycopy(tmpPassword, 0, this.credential, 0, tmpPassword.length);
                pc.clearPassword();
                password = new String(this.credential);
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("CallbackHandler does not support: " + uce.getCallback());
        }
        info[0] = username;
        info[1] = password;
        return info;
    }

    protected abstract String getUsersPassword() throws LoginException;

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        if (inputPassword == null || expectedPassword == null) {
            return false;
        }
        boolean valid = false;
        valid = this.ignorePasswordCase ? inputPassword.equalsIgnoreCase(expectedPassword) : inputPassword.equals(expectedPassword);
        return valid;
    }
}

