/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.jboss.security.ad;

import com.proveo.ad.ldap.LDAPAuthenticator;
import de.proveo.wwt.jboss.security.RTSLoginModule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProveoEFMADLDAPLoginModule
extends RTSLoginModule {
    private static final Log log = LogFactory.getLog(ProveoEFMADLDAPLoginModule.class);
    private static final String LDAP_PARAMETERS_PREFIX = "ldapAuthentication.";
    private static final String REQUIRED_ROLE_CONFIG_KEY = "requiredRole";
    private static final String CONFIG_COLUMN_ID = "ID";
    private static final String CONFIG_COLUMN_VALUE = "PARAMETER_VALUE";
    private final LDAPAuthenticator ldapAuthenticator = new LDAPAuthenticator();
    private String requiredRole;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            Map<String, String> ldapOptions = this.loadConfigurationFromDS();
            this.ldapAuthenticator.configure(ldapOptions);
            this.requiredRole = ldapOptions.get(REQUIRED_ROLE_CONFIG_KEY);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        return null;
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        String username = this.getUsername();
        try {
            if (!this.accountUtil.isLDAPAccount(username)) {
                return false;
            }
            LDAPAuthenticator.User user = this.ldapAuthenticator.authenticate(username, inputPassword);
            if (this.requiredRole != null && !user.getRoles().contains(this.requiredRole)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("validatePassword failed for " + username + ", required role missing: " + this.requiredRole));
                }
                return false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("validatePassword successfully for " + username + " with password " + inputPassword));
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("validatePassword runs for " + username + " with password " + inputPassword + " into"), (Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadConfigurationFromDS() throws SQLException {
        Connection conn = null;
        HashMap<String, String> ldapOptions = new HashMap<String, String>();
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT ID,PARAMETER_VALUE FROM configuration_parameter WHERE ID LIKE ?");
            ps.setString(1, "ldapAuthentication.%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(CONFIG_COLUMN_ID);
                String value = rs.getString(CONFIG_COLUMN_VALUE);
                key = key.substring(LDAP_PARAMETERS_PREFIX.length());
                ldapOptions.put(key, value);
            }
        }
        catch (Exception ex) {
            log.error((Object)"loadConfigurationFromDS() runs into", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return ldapOptions;
    }
}

