/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.jboss.security;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EFMAccountUtil {
    private static final Log log = LogFactory.getLog(EFMAccountUtil.class);
    private String dsJndiName;

    public String getDsJndiName() {
        return this.dsJndiName;
    }

    public void setDsJndiName(String dsJndiName) {
        this.dsJndiName = dsJndiName;
    }

    public boolean isLDAPAccount(String username) throws SQLException {
        return "LDAP".equalsIgnoreCase(this.getAuthType(username));
    }

    public boolean isLocalAccount(String username) throws SQLException {
        String authType = this.getAuthType(username);
        return authType == null || "LOCAL".equalsIgnoreCase(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAuthType(String username) throws SQLException {
        String authType = null;
        Connection conn = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
            conn = ds.getConnection();
            PreparedStatement ps = conn.prepareStatement("SELECT AUTH_TYPE FROM account WHERE USERNAME = ?");
            ps.setString(1, username);
            ps.setMaxRows(1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                authType = rs.getString("AUTH_TYPE");
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAuthType() runs into", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return authType;
    }
}

