/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.config;

import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.builder.SchemaConfigurationBuilder;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.DomUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.w3c.dom.Element;

public class CompassNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String COMPASS_CONTEXT_BEAN_POST_PROCESSOR = "org.compass.spring.support.CompassContextBeanPostProcessor";
    static /* synthetic */ Class class$org$compass$spring$LocalCompassBean;
    static /* synthetic */ Class class$org$compass$spring$LocalCompassSessionBean;

    public void init() {
        this.registerBeanDefinitionParser("compass", (BeanDefinitionParser)new CompassBeanDefinitionParser());
        this.registerBeanDefinitionParser("context", (BeanDefinitionParser)new CompassBeanDefinitionParser());
        this.registerBeanDefinitionParser("session", (BeanDefinitionParser)new CompassBeanDefinitionParser());
    }

    private static class CompassBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private CompassBeanDefinitionParser() {
        }

        protected void doParse(Element element, BeanDefinitionBuilder beanDefinitionBuilder) {
            String compassRef;
            if (element.getLocalName().equals("compass")) {
                String postProcessRef;
                String dataSourceRef;
                String id = element.getAttribute("name");
                element.setAttribute("id", id);
                SchemaConfigurationBuilder schemaConfigurationBuilder = new SchemaConfigurationBuilder();
                CompassConfiguration config = CompassConfigurationFactory.newConfiguration();
                schemaConfigurationBuilder.processCompass(element, config);
                beanDefinitionBuilder.addPropertyValue("compassConfiguration", (Object)config);
                String txManagerRef = DomUtils.getElementAttribute(element, "txManager");
                if (txManagerRef != null) {
                    beanDefinitionBuilder.addPropertyReference("transactionManager", txManagerRef);
                }
                if ((dataSourceRef = DomUtils.getElementAttribute(element, "dataSource")) != null) {
                    beanDefinitionBuilder.addPropertyReference("dataSource", dataSourceRef);
                }
                if ((postProcessRef = DomUtils.getElementAttribute(element, "postProcessor")) != null) {
                    beanDefinitionBuilder.addPropertyReference("postProcessor", postProcessRef);
                }
            } else if (element.getLocalName().equals("context")) {
                element.setAttribute("id", "" + System.currentTimeMillis());
            } else if (element.getLocalName().equals("session") && (compassRef = DomUtils.getElementAttribute(element, "compass")) != null) {
                beanDefinitionBuilder.addPropertyReference("compass", compassRef);
            }
        }

        protected Class getBeanClass(Element element) {
            if (element.getLocalName().equals("compass")) {
                return class$org$compass$spring$LocalCompassBean == null ? (class$org$compass$spring$LocalCompassBean = CompassNamespaceHandler.class$("org.compass.spring.LocalCompassBean")) : class$org$compass$spring$LocalCompassBean;
            }
            if (element.getLocalName().equals("context")) {
                try {
                    return ClassUtils.forName(CompassNamespaceHandler.COMPASS_CONTEXT_BEAN_POST_PROCESSOR);
                }
                catch (ClassNotFoundException e) {
                    throw new CompassException("Failed to find class [org.compass.spring.support.CompassContextBeanPostProcessor]");
                }
            }
            if (element.getLocalName().equals("session")) {
                return class$org$compass$spring$LocalCompassSessionBean == null ? (class$org$compass$spring$LocalCompassSessionBean = CompassNamespaceHandler.class$("org.compass.spring.LocalCompassSessionBean")) : class$org$compass$spring$LocalCompassSessionBean;
            }
            throw new CompassException("Failed to parse element [" + element.getLocalName() + "]");
        }
    }
}

