/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.gps.ActiveMirrorGpsDevice;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.device.AbstractMirrorGpsDeviceWrapper;

public class ScheduledMirrorGpsDevice
extends AbstractMirrorGpsDeviceWrapper
implements ActiveMirrorGpsDevice {
    private static Log log = LogFactory.getLog((Class)ScheduledMirrorGpsDevice.class);
    private ActiveMirrorGpsDevice gpsDevice;
    private MirrorGpsDeviceThread thread;
    private boolean daemon = true;
    private long period = 10000L;

    public ScheduledMirrorGpsDevice() {
    }

    public ScheduledMirrorGpsDevice(ActiveMirrorGpsDevice gpsDevice) {
        this.gpsDevice = gpsDevice;
        this.setGpsDevice(gpsDevice);
    }

    public void setGpsDevice(CompassGpsDevice gpsDevice) {
        if (!(gpsDevice instanceof ActiveMirrorGpsDevice)) {
            throw new IllegalArgumentException("The device must implement the ActiveMirrorGpsDevice interface");
        }
        this.gpsDevice = (ActiveMirrorGpsDevice)gpsDevice;
        super.setGpsDevice(gpsDevice);
    }

    public synchronized void start() throws CompassGpsException {
        if (this.isRunning()) {
            throw new IllegalStateException("{" + this.getName() + "} Scheduled mirror device is already running");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("{" + this.getName() + "} Starting scheduled mirror device with period [" + this.period + "ms] daemon [" + this.daemon + "]"));
        }
        this.gpsDevice.start();
        this.thread = new MirrorGpsDeviceThread(this.period);
        this.thread.setName("Compass Mirror Gps Device [" + this.getName() + "]");
        this.thread.start();
    }

    public synchronized void stop() throws CompassGpsException {
        if (!this.isRunning()) {
            throw new IllegalStateException("{" + this.getName() + "} Scheduled mirror device is already running");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("{" + this.getName() + "} Stopping scheduled mirror device"));
        }
        this.thread.cancel();
        this.thread = null;
        this.gpsDevice.stop();
    }

    public ActiveMirrorGpsDevice getWrappedGpsDevice() {
        return this.gpsDevice;
    }

    public void setWrappedGpsDevice(ActiveMirrorGpsDevice gpsDevice) {
        this.gpsDevice = gpsDevice;
        this.setGpsDevice(gpsDevice);
    }

    public void performMirroring() throws CompassGpsException {
        this.checkDeviceSet();
        this.gpsDevice.performMirroring();
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    private class MirrorGpsDeviceThread
    extends Thread {
        private long period;
        private boolean canceled;

        public MirrorGpsDeviceThread(long period) {
            this.period = period;
        }

        public void run() {
            while (!Thread.interrupted() || !this.canceled) {
                try {
                    Thread.sleep(this.period);
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    ScheduledMirrorGpsDevice.this.gpsDevice.performMirroring();
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to perform gps device mirroring", (Throwable)e);
                }
            }
        }

        public void cancel() {
            this.canceled = true;
            this.interrupt();
        }
    }
}

