/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reader;

import java.io.Reader;
import org.compass.core.engine.RepeatableReader;

public class StringWithSeparatorReader
extends Reader
implements RepeatableReader {
    private String str;
    private char separator;
    private int length;
    private int next = 0;
    private boolean readSeparator = false;

    public StringWithSeparatorReader(String s, char separator) {
        this.str = s;
        this.separator = separator;
        this.length = s.length();
    }

    public int read() {
        if (this.next >= this.length) {
            if (this.readSeparator) {
                return -1;
            }
            this.readSeparator = true;
            return this.separator;
        }
        return this.str.charAt(this.next++);
    }

    public int read(char[] cbuf, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (this.next >= this.length) {
            if (this.readSeparator) {
                return -1;
            }
            this.readSeparator = true;
            cbuf[off] = this.separator;
            return 1;
        }
        int leftOver = this.length - this.next;
        if (leftOver >= len) {
            this.str.getChars(this.next, this.next + len, cbuf, off);
            this.next += len;
            return len;
        }
        this.str.getChars(this.next, this.next + leftOver, cbuf, off);
        this.next += leftOver;
        this.readSeparator = true;
        cbuf[off + leftOver] = this.separator;
        return leftOver + 1;
    }

    public long skip(long ns) {
        throw new UnsupportedOperationException("Skip not supported");
    }

    public boolean ready() {
        return true;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) {
        throw new UnsupportedOperationException("Skip not supported");
    }

    public void reset() {
        throw new UnsupportedOperationException("Skip not supported");
    }

    public void close() {
        this.next = 0;
        this.readSeparator = false;
    }
}

