/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcDirectorySettings;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;
import org.apache.lucene.store.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.apache.lucene.store.jdbc.dialect.Dialect;
import org.apache.lucene.store.jdbc.dialect.DialectResolver;
import org.apache.lucene.store.jdbc.index.FetchPerTransactionJdbcIndexInput;
import org.apache.lucene.store.jdbc.support.JdbcTable;
import org.compass.core.CompassException;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.event.SearchEngineEventManager;
import org.compass.core.engine.event.SearchEngineLifecycleEventListener;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.store.AbstractLuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.LuceneSearchEngineStore;
import org.compass.core.lucene.engine.store.jdbc.DataSourceProvider;
import org.compass.core.lucene.engine.store.jdbc.DriverManagerDataSourceProvider;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.util.ClassUtils;

public class JdbcLuceneSearchEngineStore
extends AbstractLuceneSearchEngineStore {
    private String url;
    private JdbcDirectorySettings jdbcSettings;
    private DataSource dataSource;
    private DataSourceProvider dataSourceProvider;
    private Dialect dialect;
    private boolean managed;
    private boolean disableSchemaOperation;
    private Map cachedJdbcTables = new HashMap();

    public JdbcLuceneSearchEngineStore(String url, String subContext) {
        super(url, subContext);
        this.url = url;
    }

    public void configure(LuceneSearchEngineFactory searchEngineFactory, CompassSettings settings, CompassMapping mapping) throws CompassException {
        String dataSourceProviderClassName = settings.getSetting("compass.engine.store.jdbc.connection.provider.class", DriverManagerDataSourceProvider.class.getName());
        try {
            this.dataSourceProvider = (DataSourceProvider)ClassUtils.forName(dataSourceProviderClassName).newInstance();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Using data source provider [" + this.dataSourceProvider.getClass().getName() + "]"));
            }
            this.dataSourceProvider.configure(this.url, settings);
            this.dataSource = this.dataSourceProvider.getDataSource();
        }
        catch (Exception e) {
            throw new CompassException("Failed to configure data source provider [" + dataSourceProviderClassName + "]", e);
        }
        String dialectClassName = settings.getSetting("compass.engine.store.jdbc.dialect", null);
        if (dialectClassName == null) {
            try {
                this.dialect = new DialectResolver().getDialect(this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new ConfigurationException("Failed to auto detect dialect", e);
            }
        }
        try {
            this.dialect = (Dialect)ClassUtils.forName(dialectClassName).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to configure dialect [" + dialectClassName + "]");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using dialect [" + this.dialect.getClass().getName() + "]"));
        }
        this.managed = settings.getSettingAsBoolean("compass.engine.store.jdbc.managed", false);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using managed [" + this.managed + "]"));
        }
        if (!this.managed) {
            this.dataSource = new TransactionAwareDataSourceProxy(this.dataSource);
        }
        this.disableSchemaOperation = settings.getSettingAsBoolean("compass.engine.store.jdbc.disableSchemaOperations", false);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using disable schema operations [" + this.disableSchemaOperation + "]"));
        }
        this.jdbcSettings = new JdbcDirectorySettings();
        this.jdbcSettings.setNameColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.name.name", this.jdbcSettings.getNameColumnName()));
        this.jdbcSettings.setValueColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.value.name", this.jdbcSettings.getValueColumnName()));
        this.jdbcSettings.setSizeColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.size.name", this.jdbcSettings.getSizeColumnName()));
        this.jdbcSettings.setLastModifiedColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.lastModified.name", this.jdbcSettings.getLastModifiedColumnName()));
        this.jdbcSettings.setDeletedColumnName(settings.getSetting("compass.engine.store.jdbc.ddl.deleted.name", this.jdbcSettings.getDeletedColumnName()));
        this.jdbcSettings.setNameColumnLength(settings.getSettingAsInt("compass.engine.store.jdbc.ddl.name.length", this.jdbcSettings.getNameColumnLength()));
        this.jdbcSettings.setValueColumnLengthInK(settings.getSettingAsInt("compass.engine.store.jdbc.ddl.value.length", this.jdbcSettings.getValueColumnLengthInK()));
        this.jdbcSettings.setUseCommitLocks(settings.getSettingAsBoolean("compass.engine.store.jdbc.useCommitLocks", this.jdbcSettings.isUseCommitLocks()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using commit locks [" + this.jdbcSettings.isUseCommitLocks() + "]"));
        }
        this.jdbcSettings.setDeleteMarkDeletedDelta(settings.getSettingAsLong("compass.engine.store.jdbc.deleteMarkDeletedDelta", this.jdbcSettings.getDeleteMarkDeletedDelta()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using delete mark deleted older than [" + this.jdbcSettings.getDeleteMarkDeletedDelta() + "ms]"));
        }
        this.jdbcSettings.setQueryTimeout(settings.getSettingAsInt("compass.transaction.lockTimeout", this.jdbcSettings.getQueryTimeout()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using query timeout (transaction lock timeout) [" + this.jdbcSettings.getQueryTimeout() + "ms]"));
        }
        try {
            this.jdbcSettings.setLockClass(settings.getSettingAsClass("compass.engine.store.jdbc.lockType", this.jdbcSettings.getLockClass()));
        }
        catch (ClassNotFoundException e) {
            throw new CompassException("Failed to create jdbc lock class [" + settings.getSetting("compass.engine.store.jdbc.lockType") + "]");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using lock strategy [" + this.jdbcSettings.getLockClass().getName() + "]"));
        }
        if (this.dialect.supportTransactionalScopedBlobs() && !settings.getSettingAsBoolean("compass.engine.store.jdbc.connection.autoCommit", false)) {
            this.jdbcSettings.getDefaultFileEntrySettings().setClassSetting("indexInput.type", FetchPerTransactionJdbcIndexInput.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using transactional blobs (dialect supports it)");
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Using non transactional blobs (dialect does not supports it)");
        }
        Map fileEntries = settings.getSettingGroups("compass.engine.store.jdbc.fe");
        Iterator it = fileEntries.keySet().iterator();
        while (it.hasNext()) {
            JdbcFileEntrySettings jdbcFileEntrySettings;
            String fileEntryName = (String)it.next();
            CompassSettings compassFeSettings = (CompassSettings)fileEntries.get(fileEntryName);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Configuring file entry [" + fileEntryName + "] with settings [" + compassFeSettings + "]"));
            }
            if ((jdbcFileEntrySettings = this.jdbcSettings.getFileEntrySettingsWithoutDefault(fileEntryName)) == null) {
                jdbcFileEntrySettings = new JdbcFileEntrySettings();
            }
            Iterator feIt = compassFeSettings.keySet().iterator();
            while (feIt.hasNext()) {
                String feSetting = (String)feIt.next();
                jdbcFileEntrySettings.setSetting(feSetting, compassFeSettings.getSetting(feSetting));
            }
            this.jdbcSettings.registerFileEntrySettings(fileEntryName, jdbcFileEntrySettings);
        }
        super.configure(searchEngineFactory, settings, mapping);
    }

    protected void doClose() {
        this.dataSourceProvider.closeDataSource();
    }

    public void performScheduledTasks() throws SearchEngineException {
        String[] subIndexes = this.getSubIndexes();
        Exception last = null;
        for (int i = 0; i < subIndexes.length; ++i) {
            try {
                JdbcDirectory jdbcDirectory = (JdbcDirectory)this.getDirectoryBySubIndex(subIndexes[i], false);
                jdbcDirectory.deleteMarkDeleted();
                continue;
            }
            catch (Exception e) {
                last = e;
            }
        }
        if (last != null) {
            throw new SearchEngineException("Failed to clear mark deleted", last);
        }
    }

    protected Directory doOpenDirectoryBySubIndex(String subIndex, boolean create) throws SearchEngineException {
        String totalPath = this.subContext + "_" + subIndex;
        JdbcTable jdbcTable = (JdbcTable)this.cachedJdbcTables.get(totalPath);
        if (jdbcTable == null) {
            jdbcTable = new JdbcTable(this.jdbcSettings, this.dialect, totalPath);
            this.cachedJdbcTables.put(totalPath, jdbcTable);
        }
        JdbcDirectory dir = new JdbcDirectory(this.dataSource, jdbcTable);
        if (create) {
            try {
                this.createDirectory(dir);
            }
            catch (IOException e) {
                throw new SearchEngineException("Failed to create dir [" + totalPath + "]", e);
            }
        }
        return dir;
    }

    public void createIndex() throws SearchEngineException {
        try {
            this.deleteIndex();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.createIndex();
    }

    protected void doDeleteIndex() throws SearchEngineException {
        String[] subIndexes = this.getSubIndexes();
        for (int i = 0; i < subIndexes.length; ++i) {
            this.template.executeForSubIndex(subIndexes[i], false, new LuceneSearchEngineStore.LuceneStoreCallback(){

                public Object doWithStore(Directory dir) throws IOException {
                    JdbcLuceneSearchEngineStore.this.deleteDirectory((JdbcDirectory)dir);
                    return null;
                }
            });
        }
    }

    protected Boolean indexExists(Directory dir) throws IOException {
        try {
            boolean tableExists;
            if (this.dialect.supportsTableExists() && !(tableExists = ((JdbcDirectory)dir).tableExists())) {
                return Boolean.FALSE;
            }
        }
        catch (IOException e) {
            this.log.warn((Object)"Failed to check if index exists", (Throwable)e);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return super.indexExists(dir);
    }

    public void registerEventListeners(SearchEngine searchEngine, SearchEngineEventManager eventManager) {
        if (this.managed) {
            eventManager.registerLifecycleListener(new ManagedEventListeners());
        } else {
            eventManager.registerLifecycleListener(new NoneManagedEventListeners());
        }
    }

    protected AbstractLuceneSearchEngineStore.CopyFromHolder doBeforeCopyFrom() throws SearchEngineException {
        for (int i = 0; i < this.getSubIndexes().length; ++i) {
            final String subIndex = this.getSubIndexes()[i];
            this.template.executeForSubIndex(subIndex, false, new LuceneSearchEngineStore.LuceneStoreCallback(){

                public Object doWithStore(Directory dest) {
                    JdbcDirectory jdbcDirectory = (JdbcDirectory)dest;
                    try {
                        jdbcDirectory.deleteContent();
                    }
                    catch (IOException e) {
                        throw new SearchEngineException("Failed to delete content of [" + subIndex + "]", e);
                    }
                    return null;
                }
            });
        }
        AbstractLuceneSearchEngineStore.CopyFromHolder holder = new AbstractLuceneSearchEngineStore.CopyFromHolder();
        holder.createOriginalDirectory = false;
        return holder;
    }

    private void createDirectory(JdbcDirectory dir) throws IOException {
        if (this.disableSchemaOperation) {
            return;
        }
        dir.create();
    }

    private void deleteDirectory(JdbcDirectory dir) throws IOException {
        if (this.disableSchemaOperation) {
            dir.deleteContent();
        } else {
            dir.delete();
        }
    }

    private class NoneManagedEventListeners
    implements SearchEngineLifecycleEventListener {
        private Connection connection;

        private NoneManagedEventListeners() {
        }

        public void beforeBeginTransaction() throws SearchEngineException {
            try {
                this.connection = DataSourceUtils.getConnection(JdbcLuceneSearchEngineStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to open db connection", e);
            }
        }

        public void afterBeginTransaction() throws SearchEngineException {
        }

        public void afterPrepare() throws SearchEngineException {
        }

        public void afterCommit(boolean onePhase) throws SearchEngineException {
            try {
                DataSourceUtils.commitConnectionIfPossible(this.connection);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to commit database transcation", e);
            }
            finally {
                DataSourceUtils.releaseConnection(this.connection);
                this.connection = null;
            }
        }

        public void afterRollback() throws SearchEngineException {
            try {
                DataSourceUtils.rollbackConnectionIfPossible(this.connection);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to rollback database transcation", e);
            }
            finally {
                DataSourceUtils.releaseConnection(this.connection);
                this.connection = null;
            }
        }

        public void close() throws SearchEngineException {
        }
    }

    private class ManagedEventListeners
    implements SearchEngineLifecycleEventListener {
        private ManagedEventListeners() {
        }

        public void beforeBeginTransaction() throws SearchEngineException {
        }

        public void afterBeginTransaction() throws SearchEngineException {
        }

        public void afterPrepare() throws SearchEngineException {
        }

        public void afterCommit(boolean onePhase) throws SearchEngineException {
            Connection conn;
            try {
                conn = DataSourceUtils.getConnection(JdbcLuceneSearchEngineStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to get connection", e);
            }
            FetchPerTransactionJdbcIndexInput.releaseBlobs(conn);
            DataSourceUtils.releaseConnection(conn);
        }

        public void afterRollback() throws SearchEngineException {
            Connection conn;
            try {
                conn = DataSourceUtils.getConnection(JdbcLuceneSearchEngineStore.this.dataSource);
            }
            catch (JdbcStoreException e) {
                throw new SearchEngineException("Failed to get connection", e);
            }
            FetchPerTransactionJdbcIndexInput.releaseBlobs(conn);
            DataSourceUtils.releaseConnection(conn);
        }

        public void close() throws SearchEngineException {
        }
    }
}

