/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.io.Reader;
import java.io.Serializable;
import org.compass.core.CompassAnalyzerHelper;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.CompassQueryFilterBuilder;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.NullFirstLevelCache;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.impl.DefaultCompassAnalyzerHelper;
import org.compass.core.impl.DefaultCompassQueryBuilder;
import org.compass.core.impl.DefaultCompassQueryFilterBuilder;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.marshall.DefaultMarshallingStrategy;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.TransactionFactory;

public class DefaultCompassSession
implements InternalCompassSession {
    private InternalCompass compass;
    private CompassMapping mapping;
    private CompassMetaData compassMetaData;
    private SearchEngine searchEngine;
    private TransactionFactory transactionFactory;
    private MarshallingStrategy marshallingStrategy;
    private FirstLevelCache firstLevelCache;
    private boolean closed = false;
    private RuntimeCompassSettings runtimeSettings;

    public DefaultCompassSession(RuntimeCompassSettings runtimeSettings, InternalCompass compass, SearchEngine searchEngine, FirstLevelCache firstLevelCache) {
        this.compass = compass;
        this.mapping = compass.getMapping();
        this.compassMetaData = compass.getMetaData();
        this.transactionFactory = compass.getTransactionFactory();
        this.runtimeSettings = runtimeSettings;
        this.searchEngine = searchEngine;
        this.firstLevelCache = firstLevelCache;
        this.marshallingStrategy = new DefaultMarshallingStrategy(this.mapping, searchEngine, compass.getConverterLookup(), this);
        this.transactionFactory.tryJoinExistingTransaction(this);
    }

    public CompassSettings getSettings() {
        return this.runtimeSettings;
    }

    public Resource createResource(String alias) throws CompassException {
        return this.searchEngine.createResource(alias);
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index) throws CompassException {
        return this.searchEngine.createProperty(name, value, store, index);
    }

    public Property createProperty(String name, String value, Property.Store store, Property.Index index, Property.TermVector termVector) throws CompassException {
        return this.searchEngine.createProperty(name, value, store, index, termVector);
    }

    public Property createProperty(String name, Reader value) throws CompassException {
        return this.searchEngine.createProperty(name, value);
    }

    public Property createProperty(String name, Reader value, Property.TermVector termVector) throws CompassException {
        return this.searchEngine.createProperty(name, value, termVector);
    }

    public Property createProperty(String name, byte[] value, Property.Store store) throws CompassException {
        return this.searchEngine.createProperty(name, value, store);
    }

    public CompassQueryBuilder createQueryBuilder() throws CompassException {
        return this.queryBuilder();
    }

    public CompassQueryBuilder queryBuilder() throws CompassException {
        SearchEngineQueryBuilder searchEngineQueryBuilder = this.searchEngine.queryBuilder();
        return new DefaultCompassQueryBuilder(searchEngineQueryBuilder, this);
    }

    public CompassQueryFilterBuilder createQueryFilterBuilder() throws CompassException {
        return this.queryFilterBuilder();
    }

    public CompassQueryFilterBuilder queryFilterBuilder() throws CompassException {
        SearchEngineQueryFilterBuilder searchEngineQueryFilterBuilder = this.searchEngine.queryFilterBuilder();
        return new DefaultCompassQueryFilterBuilder(searchEngineQueryFilterBuilder, this);
    }

    public CompassAnalyzerHelper analyzerHelper() throws CompassException {
        SearchEngineAnalyzerHelper analyzerHelper = this.searchEngine.analyzerHelper();
        return new DefaultCompassAnalyzerHelper(analyzerHelper, this);
    }

    public CompassTransaction beginTransaction() throws CompassException {
        return this.transactionFactory.beginTransaction(this, null);
    }

    public CompassTransaction beginTransaction(CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        if (transactionIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            this.firstLevelCache = new NullFirstLevelCache();
        }
        return this.transactionFactory.beginTransaction(this, transactionIsolation);
    }

    public void flush() throws CompassException {
        this.searchEngine.flush();
    }

    public void delete(Resource resource) throws CompassException {
        this.firstLevelCache.evict(((InternalResource)resource).resourceKey());
        this.searchEngine.delete(resource);
    }

    public void delete(String alias, Object obj) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(alias, obj);
        this.delete(idResource);
    }

    public void delete(Class clazz, Object obj) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, obj);
        this.delete(idResource);
    }

    public void delete(Object obj) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(obj);
        this.delete(idResource);
    }

    public Resource getResource(Class clazz, Serializable id) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, (Object)id);
        return this.getResourceByIdResource(idResource);
    }

    public Resource getResource(String alias, Serializable id) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(alias, (Object)id);
        return this.getResourceByIdResource(idResource);
    }

    public Resource getResourceByIdResource(Resource idResource) {
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.get(idResource);
        this.firstLevelCache.setResource(key, value);
        return value;
    }

    public Object get(Class clazz, Serializable id) throws CompassException {
        Resource resource = this.getResource(clazz, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource);
    }

    public Object get(String alias, Serializable id) throws CompassException {
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource);
    }

    public Object get(String alias, Serializable id, MarshallingContext context) throws CompassException {
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource, context);
    }

    public Object getByResource(Resource resource) {
        return this.getByResource(resource, null);
    }

    public Object getByResource(Resource resource, MarshallingContext context) {
        ResourceKey key = ((InternalResource)resource).resourceKey();
        Object cachedValue = this.firstLevelCache.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Object value = context == null ? this.marshallingStrategy.unmarshall(resource) : this.marshallingStrategy.unmarshall(resource, context);
        this.firstLevelCache.set(key, value);
        return value;
    }

    public Resource loadResource(Class clazz, Serializable id) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, (Object)id);
        return this.loadResourceByIdResource(idResource);
    }

    public Resource loadResource(String alias, Serializable id) throws CompassException {
        Resource idResource = this.marshallingStrategy.marshallIds(alias, (Object)id);
        return this.loadResourceByIdResource(idResource);
    }

    public Resource loadResourceByIdResource(Resource idResource) {
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.load(idResource);
        this.firstLevelCache.setResource(key, value);
        return value;
    }

    public Object load(Class clazz, Serializable id) throws CompassException {
        Resource resource = this.loadResource(clazz, id);
        return this.getByResource(resource);
    }

    public Object load(String alias, Serializable id) throws CompassException {
        Resource resource = this.loadResource(alias, id);
        return this.getByResource(resource);
    }

    public CompassHits find(String query) throws CompassException {
        return this.createQueryBuilder().queryString(query).toQuery().hits();
    }

    public void create(String alias, Object object) throws CompassException {
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        this.searchEngine.create(resource);
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.set(key, object);
    }

    public void save(String alias, Object object) throws CompassException {
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        this.searchEngine.save(resource);
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.set(key, object);
    }

    public void create(Object object) throws CompassException {
        Resource resource = this.marshallingStrategy.marshall(object);
        this.searchEngine.create(resource);
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.set(key, object);
    }

    public void save(Object object) throws CompassException {
        Resource resource = this.marshallingStrategy.marshall(object);
        this.searchEngine.save(resource);
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.set(key, object);
    }

    public void delete(CompassQuery query) throws CompassException {
        CompassHits hits = query.hits();
        for (int i = 0; i < hits.length(); ++i) {
            this.delete(hits.resource(i));
        }
    }

    public void evict(Object obj) {
        Resource idResource = this.marshallingStrategy.marshallIds(obj.getClass(), obj);
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    public void evict(String alias, Object id) {
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    public void evict(Resource resource) {
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    public void evictAll() {
        this.firstLevelCache.evictAll();
    }

    public void close() throws CompassException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        CompassSession transactionBoundSession = this.transactionFactory.getTransactionBoundSession();
        if (transactionBoundSession == null || transactionBoundSession != this) {
            this.firstLevelCache.evictAll();
            this.searchEngine.close();
        }
    }

    public InternalCompass getCompass() {
        return this.compass;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public MarshallingStrategy getMarshallingStrategy() {
        return this.marshallingStrategy;
    }

    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    public CompassMapping getMapping() {
        return this.mapping;
    }

    public CompassMetaData getMetaData() {
        return this.compassMetaData;
    }
}

