/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.xsem;

import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.Converter;
import org.compass.core.converter.xsem.PoolXmlContentConverterWrapper;
import org.compass.core.converter.xsem.PrototypeXmlContentConverterWrapper;
import org.compass.core.converter.xsem.SingletonXmlContentConverterWrapper;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.util.ClassUtils;
import org.compass.core.xml.XmlObject;

public class XmlContentMappingConverter
implements Converter,
CompassConfigurable {
    private static final Log log = LogFactory.getLog((Class)XmlContentMappingConverter.class);
    private XmlContentConverter xmlContentConverter;

    public void configure(CompassSettings settings) throws CompassException {
        String wrapper = settings.getSetting("xmlContentConverter.wrapper", "prototype");
        if (log.isDebugEnabled()) {
            String type = settings.getSetting("xmlContentConverter.type");
            log.debug((Object)("Using xmlContentMapping [" + type + "] with wrapper [" + wrapper + "] and settings [" + settings + "]"));
        }
        if ("prototype".equals(wrapper)) {
            this.xmlContentConverter = new PrototypeXmlContentConverterWrapper();
        } else if ("singleton".equals(wrapper)) {
            this.xmlContentConverter = new SingletonXmlContentConverterWrapper();
        } else if ("pool".equals(wrapper)) {
            this.xmlContentConverter = new PoolXmlContentConverterWrapper();
        } else {
            try {
                this.xmlContentConverter = (XmlContentConverter)ClassUtils.forName(wrapper).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create wrapper [" + wrapper + "], either the class name or the short name for existing wrappers is wrong", e);
            }
        }
        if (this.xmlContentConverter instanceof CompassConfigurable) {
            ((CompassConfigurable)((Object)this.xmlContentConverter)).configure(settings);
        }
    }

    public XmlContentConverter getXmlContentConverter() {
        return this.xmlContentConverter;
    }

    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        SearchEngine searchEngine = context.getSearchEngine();
        if (root == null && !this.handleNulls(context)) {
            return false;
        }
        XmlObject xmlObject = (XmlObject)root;
        XmlContentMapping xmlContentMapping = (XmlContentMapping)mapping;
        String sValue = this.xmlContentConverter.toXml(xmlObject);
        String propertyName = xmlContentMapping.getPath().getPath();
        Property p = searchEngine.createProperty(propertyName, sValue, xmlContentMapping);
        resource.addProperty(p);
        return xmlContentMapping.getStore() != Property.Store.NO;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        XmlContentMapping xmlContentMapping = (XmlContentMapping)mapping;
        String propertyName = xmlContentMapping.getPath().getPath();
        Property p = resource.getProperty(propertyName);
        if (p == null || this.isNullValue(context, p.getStringValue())) {
            return null;
        }
        return this.xmlContentConverter.fromXml(resource.getAlias(), new StringReader(p.getStringValue()));
    }

    protected boolean handleNulls(MarshallingContext context) {
        return context.handleNulls();
    }

    protected boolean isNullValue(MarshallingContext context, String value) {
        return context.getSearchEngine().isNullValue(value);
    }
}

