/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.io.Serializable;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.osem.AbstractRefAliasMappingConverter;
import org.compass.core.engine.SearchEngine;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.HasRefAliasMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.marshall.MarshallingContext;

public class ReferenceMappingConverter
extends AbstractRefAliasMappingConverter {
    protected boolean doMarshall(Resource resource, Object root, HasRefAliasMapping hasRefAliasMapping, ClassMapping refMapping, MarshallingContext context) throws ConversionException {
        Object current = context.getAttribute("current");
        ReferenceMapping referenceMapping = (ReferenceMapping)hasRefAliasMapping;
        if (refMapping.isSupportUnmarshall()) {
            SearchEngine searchEngine = context.getSearchEngine();
            if (refMapping.isPoly() && refMapping.getPolyClass() == null) {
                String className = root.getClass().getName();
                Property p = searchEngine.createProperty(refMapping.getClassPath().getPath(), className, Property.Store.YES, Property.Index.UN_TOKENIZED);
                resource.addProperty(p);
            }
        }
        boolean stored = context.getMarshallingStrategy().marshallIds(resource, refMapping, root, context);
        if (referenceMapping.getRefCompMapping() != null) {
            context.setAttribute("parent", current);
            stored |= referenceMapping.getRefCompMapping().getConverter().marshall(resource, root, referenceMapping.getRefCompMapping(), context);
        }
        return stored;
    }

    protected Object doUnmarshall(Resource resource, HasRefAliasMapping hasRefAliasMapping, ClassMapping refMapping, MarshallingContext context) throws ConversionException {
        Object[] ids = context.getMarshallingStrategy().unmarshallIds(refMapping, resource, context);
        if (ids == null) {
            return null;
        }
        return context.getSession().get(refMapping.getAlias(), (Serializable)ids, context);
    }

    protected boolean rollbackClassNameOnPoly() {
        return false;
    }
}

